/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.JvmOptions;
import io.quarkus.bootstrap.model.JvmOptionsBuilder;
import io.quarkus.bootstrap.model.Mappable;
import io.quarkus.bootstrap.model.MappableCollectionFactory;
import io.quarkus.maven.dependency.ArtifactKey;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExtensionDevModeConfig
implements Serializable,
Mappable {
    private final ArtifactKey extensionKey;
    private final JvmOptions jvmOptions;
    private final Set<String> lockJvmOptions;

    static ExtensionDevModeConfig fromMap(Map<String, Object> map) {
        JvmOptions jvmOptions = null;
        Collection jvmOptionsMap = (Collection)map.get("jvm-options");
        if (jvmOptionsMap != null) {
            JvmOptionsBuilder optionsBuilder = new JvmOptionsBuilder();
            for (Map jvmOptionMap : jvmOptionsMap) {
                optionsBuilder.addAllToGroup(jvmOptionMap.get("group").toString(), jvmOptionMap.get("name").toString(), (Collection)jvmOptionMap.get("values"));
            }
            jvmOptions = optionsBuilder.build();
        }
        Collection lockOptions = (Collection)map.get("lock-jvm-options");
        return new ExtensionDevModeConfig(ArtifactKey.fromString(map.get("extension").toString()), jvmOptions, lockOptions == null ? Set.of() : new HashSet(lockOptions));
    }

    public ExtensionDevModeConfig(ArtifactKey extensionKey, JvmOptions jvmOptions, Set<String> lockDefaultJvmOptions) {
        this.extensionKey = extensionKey;
        this.jvmOptions = jvmOptions;
        this.lockJvmOptions = lockDefaultJvmOptions;
    }

    public ArtifactKey getExtensionKey() {
        return this.extensionKey;
    }

    public JvmOptions getJvmOptions() {
        return this.jvmOptions;
    }

    public Set<String> getLockJvmOptions() {
        return this.lockJvmOptions;
    }

    @Override
    public Map<String, Object> asMap(MappableCollectionFactory factory) {
        Map<String, Object> map = factory.newMap(3);
        map.put("extension", this.extensionKey.toGacString());
        if (!this.jvmOptions.isEmpty()) {
            map.put("jvm-options", Mappable.iterableAsMaps(this.jvmOptions, factory));
        }
        if (!this.lockJvmOptions.isEmpty()) {
            map.put("lock-jvm-options", Mappable.toStringCollection(this.lockJvmOptions, factory));
        }
        return map;
    }
}

