/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.dependency;

import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.maven.dependency.AbstractDependencyBuilder;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ResolvedArtifactDependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ResolvedDependencyBuilder
extends AbstractDependencyBuilder<ResolvedDependencyBuilder, ResolvedDependency>
implements ResolvedDependency {
    PathCollection resolvedPaths;
    WorkspaceModule workspaceModule;
    private volatile ArtifactCoords coords;
    private Set<ArtifactCoords> deps = Set.of();

    public static ResolvedDependencyBuilder newInstance() {
        return new ResolvedDependencyBuilder();
    }

    @Override
    public PathCollection getResolvedPaths() {
        return this.resolvedPaths;
    }

    public ResolvedDependencyBuilder setResolvedPath(Path path) {
        this.resolvedPaths = path == null ? null : PathList.of(path);
        return this;
    }

    public ResolvedDependencyBuilder setResolvedPaths(PathCollection resolvedPaths) {
        this.resolvedPaths = resolvedPaths;
        return this;
    }

    @Override
    public WorkspaceModule getWorkspaceModule() {
        return this.workspaceModule;
    }

    public ResolvedDependencyBuilder setWorkspaceModule(WorkspaceModule projectModule) {
        this.workspaceModule = projectModule;
        if (projectModule != null) {
            this.setWorkspaceModule();
        }
        return this;
    }

    public ArtifactCoords getArtifactCoords() {
        return this.coords == null ? (this.coords = ArtifactCoords.of(this.groupId, this.artifactId, this.classifier, this.type, this.version)) : this.coords;
    }

    public ResolvedDependencyBuilder addDependency(ArtifactCoords coords) {
        if (coords != null) {
            if (this.deps.isEmpty()) {
                this.deps = new HashSet<ArtifactCoords>();
            }
            this.deps.add(coords);
        }
        return this;
    }

    public ResolvedDependencyBuilder addDependencies(Collection<ArtifactCoords> deps) {
        if (!deps.isEmpty()) {
            if (this.deps.isEmpty()) {
                this.deps = new HashSet<ArtifactCoords>(deps);
            } else {
                this.deps.addAll(deps);
            }
        }
        return this;
    }

    @Override
    public Collection<ArtifactCoords> getDependencies() {
        return this.deps;
    }

    @Override
    public ResolvedDependency build() {
        return new ResolvedArtifactDependency(this);
    }
}

