/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.impl.InjectionPointProvider;
import io.quarkus.arc.runtime.ConfigStaticInitCheck;
import io.quarkus.arc.runtime.ConfigStaticInitValues;
import io.quarkus.runtime.ExecutionMode;
import io.quarkus.runtime.annotations.StaticInitSafe;
import io.smallrye.config.SmallRyeConfig;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@ConfigStaticInitCheck
@Priority(value=0)
@Interceptor
public class ConfigStaticInitCheckInterceptor {
    private static final Logger LOG = Logger.getLogger(ConfigStaticInitCheckInterceptor.class);
    @Inject
    ConfigStaticInitValues configValues;

    @AroundInvoke
    Object aroundInvoke(InvocationContext context) throws Exception {
        ConfigStaticInitCheckInterceptor.recordConfigValue(null, this.configValues);
        return context.proceed();
    }

    static void recordConfigValue(InjectionPoint injectionPoint, ConfigStaticInitValues configValues) {
        if (ExecutionMode.current() != ExecutionMode.STATIC_INIT) {
            return;
        }
        if (injectionPoint == null) {
            injectionPoint = InjectionPointProvider.get();
        }
        if (injectionPoint == null) {
            throw new IllegalStateException("No current injection point found");
        }
        ConfigProperty configProperty = null;
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!(qualifier instanceof ConfigProperty)) continue;
            configProperty = (ConfigProperty)qualifier;
        }
        if (configProperty == null || injectionPoint.getAnnotated().isAnnotationPresent(StaticInitSafe.class)) {
            return;
        }
        String propertyName = configProperty.name();
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        String value = config.getConfigValue(propertyName).getValue();
        if (value == null) {
            value = ConfigStaticInitCheckInterceptor.getDefaultValue(injectionPoint, configProperty);
        }
        if (value == null) {
            LOG.debugf("No config value found for %s", (Object)propertyName);
            return;
        }
        if (configValues == null) {
            configValues = (ConfigStaticInitValues)Arc.container().instance(ConfigStaticInitValues.class, new Annotation[0]).get();
        }
        configValues.recordConfigValue(injectionPoint, propertyName, value);
    }

    private static String getDefaultValue(InjectionPoint injectionPoint, ConfigProperty configProperty) {
        String str = configProperty.defaultValue();
        if (!"org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(str)) {
            return str;
        }
        if (injectionPoint.getType() instanceof Class && ((Class)injectionPoint.getType()).isPrimitive()) {
            if (injectionPoint.getType() == Character.TYPE) {
                return null;
            }
            if (injectionPoint.getType() == Boolean.TYPE) {
                return "false";
            }
            return "0";
        }
        return null;
    }
}

