/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime.context;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextController;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class ArcContextProvider
implements ThreadContextProvider {
    protected static final ThreadContextController NOOP_CONTROLLER = new ThreadContextController(){

        public void endContext() throws IllegalStateException {
        }
    };

    public ThreadContextSnapshot currentContext(Map<String, String> map) {
        ArcContainer arc = Arc.container();
        if (arc == null || !arc.isRunning()) {
            return null;
        }
        final InjectableContext.ContextState state = this.isContextActiveOnThisThread(arc) ? arc.requestContext().getState() : null;
        return new ThreadContextSnapshot(){

            public ThreadContextController begin() {
                Object controller;
                ArcContainer arcContainer = Arc.container();
                if (arcContainer == null || !arcContainer.isRunning()) {
                    return NOOP_CONTROLLER;
                }
                final ManagedContext requestContext = arcContainer.requestContext();
                if (ArcContextProvider.this.isContextActiveOnThisThread(arcContainer)) {
                    final InjectableContext.ContextState stateToRestore = requestContext.getState();
                    requestContext.deactivate();
                    if (state != null) {
                        requestContext.activate(state);
                    }
                    controller = new ThreadContextController(){

                        public void endContext() throws IllegalStateException {
                            if (state != null) {
                                requestContext.deactivate();
                            }
                            requestContext.activate(stateToRestore);
                        }
                    };
                } else {
                    if (state != null) {
                        requestContext.activate(state);
                    }
                    controller = new ThreadContextController(){

                        public void endContext() throws IllegalStateException {
                            if (state != null) {
                                requestContext.deactivate();
                            }
                        }
                    };
                }
                return controller;
            }
        };
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> map) {
        ArcContainer arc = Arc.container();
        if (arc == null || !arc.isRunning()) {
            return null;
        }
        return new ThreadContextSnapshot(){

            public ThreadContextController begin() {
                ThreadContextController controller;
                ArcContainer arcContainer = Arc.container();
                if (arcContainer == null || !arcContainer.isRunning()) {
                    return NOOP_CONTROLLER;
                }
                final ManagedContext requestContext = arcContainer.requestContext();
                if (ArcContextProvider.this.isContextActiveOnThisThread(arcContainer)) {
                    InjectableContext.ContextState stateToRestore = requestContext.getState();
                    requestContext.deactivate();
                    requestContext.activate();
                    controller = () -> {
                        requestContext.deactivate();
                        requestContext.activate(stateToRestore);
                    };
                } else {
                    requestContext.activate();
                    controller = new ThreadContextController(){

                        public void endContext() throws IllegalStateException {
                            requestContext.deactivate();
                        }
                    };
                }
                return controller;
            }
        };
    }

    public String getThreadContextType() {
        return "CDI";
    }

    private boolean isContextActiveOnThisThread(ArcContainer arc) {
        return arc.requestContext().isActive();
    }
}

