/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.SuppressConditionGeneratorBuildItem;
import io.quarkus.arc.lookup.LookupIfProperty;
import io.quarkus.arc.lookup.LookupUnlessProperty;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.runtime.SuppressConditions;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.desc.MethodDesc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class LookupConditionsProcessor {
    private static final DotName LOOK_UP_IF_PROPERTY = DotName.createSimple((String)LookupIfProperty.class.getName());
    private static final DotName LOOK_UP_IF_CONTAINER = DotName.createSimple((String)LookupIfProperty.List.class.getName());
    private static final DotName LOOK_UP_UNLESS_PROPERTY = DotName.createSimple((String)LookupUnlessProperty.class.getName());
    private static final DotName LOOK_UP_UNLESS_PROPERTY_CONTAINER = DotName.createSimple((String)LookupUnlessProperty.List.class.getName());
    public static final Set<DotName> LOOKUP_BEAN_ANNOTATIONS = Set.of(LOOK_UP_IF_PROPERTY, LOOK_UP_IF_CONTAINER, LOOK_UP_UNLESS_PROPERTY, LOOK_UP_UNLESS_PROPERTY_CONTAINER);
    private static final String NAME = "name";
    private static final String STRING_VALUE = "stringValue";
    private static final String LOOKUP_IF_MISSING = "lookupIfMissing";
    private static final MethodDesc SUPPRESS_IF_PROPERTY = MethodDesc.of(SuppressConditions.class, (String)"suppressIfProperty", Boolean.TYPE, (Class[])new Class[]{String.class, String.class, Boolean.TYPE});
    private static final MethodDesc SUPPRESS_UNLESS_PROPERTY = MethodDesc.of(SuppressConditions.class, (String)"suppressUnlessProperty", Boolean.TYPE, (Class[])new Class[]{String.class, String.class, Boolean.TYPE});

    @BuildStep
    void suppressConditionsGenerators(BuildProducer<SuppressConditionGeneratorBuildItem> generators, BeanArchiveIndexBuildItem beanArchiveIndex) {
        final IndexView index = beanArchiveIndex.getIndex();
        generators.produce((BuildItem)new SuppressConditionGeneratorBuildItem(new Function<BeanInfo, Consumer<BlockCreator>>(){

            @Override
            public Consumer<BlockCreator> apply(BeanInfo bean) {
                Optional maybeTarget = bean.getTarget();
                if (maybeTarget.isPresent()) {
                    AnnotationTarget target = (AnnotationTarget)maybeTarget.get();
                    final List<AnnotationInstance> ifPropertyList = LookupConditionsProcessor.this.findAnnotations(target, LOOK_UP_IF_PROPERTY, LOOK_UP_IF_CONTAINER, index);
                    final List<AnnotationInstance> unlessPropertyList = LookupConditionsProcessor.this.findAnnotations(target, LOOK_UP_UNLESS_PROPERTY, LOOK_UP_UNLESS_PROPERTY_CONTAINER, index);
                    if (!ifPropertyList.isEmpty() || !unlessPropertyList.isEmpty()) {
                        return new Consumer<BlockCreator>(){

                            @Override
                            public void accept(BlockCreator suppressed) {
                                Expr result;
                                boolean lookupIfMissing;
                                AnnotationValue lookupIfMissingValue;
                                String expectedStringValue;
                                String propertyName;
                                for (AnnotationInstance ifProperty : ifPropertyList) {
                                    propertyName = ifProperty.value(LookupConditionsProcessor.NAME).asString();
                                    expectedStringValue = ifProperty.value(LookupConditionsProcessor.STRING_VALUE).asString();
                                    lookupIfMissingValue = ifProperty.value(LookupConditionsProcessor.LOOKUP_IF_MISSING);
                                    lookupIfMissing = lookupIfMissingValue != null && lookupIfMissingValue.asBoolean();
                                    result = suppressed.invokeStatic(SUPPRESS_IF_PROPERTY, new Expr[]{Const.of((String)propertyName), Const.of((String)expectedStringValue), Const.of((boolean)lookupIfMissing)});
                                    suppressed.if_(result, BlockCreator::returnTrue);
                                }
                                for (AnnotationInstance unlessProperty : unlessPropertyList) {
                                    propertyName = unlessProperty.value(LookupConditionsProcessor.NAME).asString();
                                    expectedStringValue = unlessProperty.value(LookupConditionsProcessor.STRING_VALUE).asString();
                                    lookupIfMissingValue = unlessProperty.value(LookupConditionsProcessor.LOOKUP_IF_MISSING);
                                    lookupIfMissing = lookupIfMissingValue != null && lookupIfMissingValue.asBoolean();
                                    result = suppressed.invokeStatic(SUPPRESS_UNLESS_PROPERTY, new Expr[]{Const.of((String)propertyName), Const.of((String)expectedStringValue), Const.of((boolean)lookupIfMissing)});
                                    suppressed.if_(result, BlockCreator::returnTrue);
                                }
                            }
                        };
                    }
                }
                return null;
            }
        }));
    }

    List<AnnotationInstance> findAnnotations(AnnotationTarget target, DotName annotationName, DotName containingAnnotationName, IndexView index) {
        AnnotationInstance annotation;
        AnnotationInstance container = switch (target.kind()) {
            case AnnotationTarget.Kind.CLASS -> {
                annotation = target.asClass().declaredAnnotation(annotationName);
                yield target.asClass().declaredAnnotation(containingAnnotationName);
            }
            case AnnotationTarget.Kind.FIELD -> {
                annotation = target.asField().annotation(annotationName);
                yield target.asField().annotation(containingAnnotationName);
            }
            case AnnotationTarget.Kind.METHOD -> {
                annotation = target.asMethod().annotation(annotationName);
                yield target.asMethod().annotation(containingAnnotationName);
            }
            default -> throw new IllegalStateException("Invalid bean target: " + String.valueOf(target));
        };
        if (annotation == null && container == null) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationInstance> ret = new ArrayList<AnnotationInstance>();
        if (annotation != null) {
            ret.add(annotation);
        }
        if (container != null) {
            Collections.addAll(ret, container.value().asNestedArray());
        }
        return ret;
    }
}

