/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.QualifierRegistrarBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.logging.Logger;

public class AutoInjectFieldProcessor {
    private static final Logger LOGGER = Logger.getLogger(AutoInjectFieldProcessor.class);

    @BuildStep
    void autoInjectQualifiers(BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<AutoInjectAnnotationBuildItem> autoInjectAnnotations, List<QualifierRegistrarBuildItem> qualifierRegistrars) {
        ArrayList<DotName> qualifiers = new ArrayList<DotName>();
        for (AnnotationInstance qualifier : beanArchiveIndex.getIndex().getAnnotations(DotNames.QUALIFIER)) {
            qualifiers.add(qualifier.target().asClass().name());
        }
        for (QualifierRegistrarBuildItem registrar : qualifierRegistrars) {
            qualifiers.addAll(registrar.getQualifierRegistrar().getAdditionalQualifiers().keySet());
        }
        autoInjectAnnotations.produce((BuildItem)new AutoInjectAnnotationBuildItem(qualifiers));
    }

    @BuildStep
    void annotationTransformer(ArcConfig config, List<AutoInjectAnnotationBuildItem> autoInjectAnnotations, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) throws Exception {
        if (!config.autoInjectFields()) {
            return;
        }
        final ArrayList<DotName> annotationNames = new ArrayList<DotName>();
        for (AutoInjectAnnotationBuildItem autoInjectAnnotation : autoInjectAnnotations) {
            annotationNames.addAll(autoInjectAnnotation.getAnnotationNames());
        }
        if (annotationNames.isEmpty()) {
            return;
        }
        LOGGER.debugf("Add missing @Inject to fields annotated with %s", annotationNames);
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.FIELD;
            }

            public int getPriority() {
                return 999;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                Collection fieldAnnotations = ctx.getAnnotations();
                FieldInfo field = ctx.getTarget().asField();
                if (Modifier.isStatic(field.flags()) || Modifier.isFinal(field.flags()) || Annotations.contains((Collection)fieldAnnotations, (DotName)DotNames.INJECT) || Annotations.contains((Collection)fieldAnnotations, (DotName)DotNames.PRODUCES)) {
                    return;
                }
                if (Annotations.containsAny((Collection)fieldAnnotations, (Iterable)annotationNames)) {
                    ctx.transform().add(DotNames.INJECT, new AnnotationValue[0]).done();
                    return;
                }
            }
        }));
    }
}

