/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.devui;

import io.smallrye.common.annotation.SuppressForbidden;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class Name
implements Comparable<Name> {
    private final String name;
    private final String simpleName;

    public static Name from(DotName dotName) {
        return new Name(dotName.toString(), dotName.withoutPackagePrefix());
    }

    @SuppressForbidden(reason="Type.toString() is what we need here")
    public static Name from(Type type) {
        return new Name(type.toString(), Name.createSimpleName(type));
    }

    public static Name from(AnnotationInstance annotation) {
        return new Name(annotation.toString(false), Name.createSimple(annotation));
    }

    private Name(String name, String simpleName) {
        this.name = Objects.requireNonNull(name);
        this.simpleName = simpleName;
    }

    public Name(String name) {
        this(name, null);
    }

    public String getSimpleName() {
        return this.simpleName != null ? this.simpleName : this.name;
    }

    public String getName() {
        return this.name;
    }

    @SuppressForbidden(reason="Type.toString() is what we need here, in the ARRAY case")
    static String createSimpleName(Type type) {
        switch (type.kind()) {
            case CLASS: {
                return Name.createSimple(type.name().toString());
            }
            case PARAMETERIZED_TYPE: {
                return Name.createSimple(type.asParameterizedType());
            }
            case ARRAY: {
                Type component = type.asArrayType().constituent();
                if (component.kind() != Type.Kind.CLASS) break;
                return Name.createSimple(type.toString());
            }
        }
        return null;
    }

    static String createSimple(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            return name.substring(lastDot + 1);
        }
        return name;
    }

    static String createSimple(ParameterizedType parameterizedType) {
        StringBuilder builder = new StringBuilder();
        builder.append(Name.createSimple(parameterizedType.name().toString()));
        List args = parameterizedType.arguments();
        if (!args.isEmpty()) {
            builder.append('<');
            Iterator it = args.iterator();
            while (it.hasNext()) {
                builder.append(Name.createSimpleName((Type)it.next()));
                if (!it.hasNext()) continue;
                builder.append(", ");
            }
            builder.append('>');
        }
        return builder.toString();
    }

    static String createSimple(AnnotationInstance annotation) {
        StringBuilder builder = new StringBuilder("@").append(Name.createSimple(annotation.name().toString()));
        List values = annotation.values();
        if (!values.isEmpty()) {
            builder.append("(");
            Iterator it = values.iterator();
            while (it.hasNext()) {
                builder.append(it.next());
                if (!it.hasNext()) continue;
                builder.append(",");
            }
            builder.append(')');
        }
        return builder.toString();
    }

    @Override
    public int compareTo(Name other) {
        int result = Boolean.compare(this.isQuarkusClassName(), other.isQuarkusClassName());
        if (result != 0) {
            return result;
        }
        return this.name.compareTo(other.name);
    }

    public String toString() {
        return this.name;
    }

    private boolean isQuarkusClassName() {
        return this.name.startsWith("io.quarkus");
    }
}

