/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.analytics.util;

import io.quarkus.analytics.dto.config.Identity;
import io.quarkus.analytics.dto.config.LocalConfig;
import io.quarkus.analytics.dto.config.RemoteConfig;
import io.quarkus.analytics.dto.segment.Track;
import io.quarkus.analytics.dto.segment.TrackEventType;
import io.quarkus.analytics.dto.segment.TrackProperties;
import io.quarkus.bootstrap.json.Json;
import io.quarkus.bootstrap.json.JsonArray;
import io.quarkus.bootstrap.json.JsonBoolean;
import io.quarkus.bootstrap.json.JsonDouble;
import io.quarkus.bootstrap.json.JsonInteger;
import io.quarkus.bootstrap.json.JsonMember;
import io.quarkus.bootstrap.json.JsonObject;
import io.quarkus.bootstrap.json.JsonReader;
import io.quarkus.bootstrap.json.JsonString;
import io.quarkus.bootstrap.json.JsonValue;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JsonSerializer {
    private JsonSerializer() {
    }

    public static String toJson(RemoteConfig config) {
        Json.JsonObjectBuilder builder = Json.object();
        builder.put("active", config.isActive());
        if (config.getDenyAnonymousIds() != null) {
            builder.put("deny_anonymous_ids", JsonSerializer.toJsonArray(config.getDenyAnonymousIds()));
        }
        if (config.getDenyQuarkusVersions() != null) {
            builder.put("deny_quarkus_versions", JsonSerializer.toJsonArray(config.getDenyQuarkusVersions()));
        }
        if (config.getRefreshInterval() != null) {
            builder.put("refresh_interval", config.getRefreshInterval().toString());
        }
        return JsonSerializer.toJsonString(builder);
    }

    public static RemoteConfig parseRemoteConfig(String json) {
        JsonValue refreshInterval;
        JsonArray denyQuarkusVersions;
        JsonArray denyAnonymousIds;
        JsonObject obj = (JsonObject)JsonReader.of((String)json).read();
        RemoteConfig config = new RemoteConfig();
        JsonBoolean active = (JsonBoolean)obj.get("active");
        if (active != null) {
            config.setActive(active.value());
        }
        if ((denyAnonymousIds = (JsonArray)obj.get("deny_anonymous_ids")) != null) {
            config.setDenyAnonymousIds(JsonSerializer.toStringList(denyAnonymousIds));
        }
        if ((denyQuarkusVersions = (JsonArray)obj.get("deny_quarkus_versions")) != null) {
            config.setDenyQuarkusVersions(JsonSerializer.toStringList(denyQuarkusVersions));
        }
        if ((refreshInterval = obj.get("refresh_interval")) != null) {
            if (refreshInterval instanceof JsonString) {
                JsonString str = (JsonString)refreshInterval;
                config.setRefreshInterval(Duration.parse(str.value()));
            } else if (refreshInterval instanceof JsonInteger) {
                JsonInteger intVal = (JsonInteger)refreshInterval;
                config.setRefreshInterval(Duration.ofSeconds(intVal.longValue()));
            } else if (refreshInterval instanceof JsonDouble) {
                JsonDouble doubleVal = (JsonDouble)refreshInterval;
                config.setRefreshInterval(Duration.ofSeconds((long)doubleVal.value()));
            }
        }
        return config;
    }

    public static String toJson(LocalConfig config) {
        Json.JsonObjectBuilder builder = Json.object();
        builder.put("disabled", config.isDisabled());
        return JsonSerializer.toJsonString(builder);
    }

    public static LocalConfig parseLocalConfig(String json) {
        JsonObject obj = (JsonObject)JsonReader.of((String)json).read();
        LocalConfig config = new LocalConfig();
        JsonBoolean disabled = (JsonBoolean)obj.get("disabled");
        if (disabled != null) {
            config.setDisabled(disabled.value());
        }
        return config;
    }

    public static String toJson(Identity identity) {
        Json.JsonObjectBuilder builder = Json.object();
        if (identity.getUserId() != null) {
            builder.put("userId", identity.getUserId());
        }
        if (identity.getContext() != null) {
            builder.put("context", JsonSerializer.toJsonObject(identity.getContext()));
        }
        if (identity.getTimestamp() != null) {
            builder.put("timestamp", identity.getTimestamp().toString());
        }
        return JsonSerializer.toJsonString(builder);
    }

    public static String toJson(Track track) {
        Json.JsonObjectBuilder builder = Json.object();
        if (track.getUserId() != null) {
            builder.put("userId", track.getUserId());
        }
        if (track.getEvent() != null) {
            builder.put("event", track.getEvent().name());
        }
        if (track.getProperties() != null) {
            builder.put("properties", JsonSerializer.toJsonObject(track.getProperties()));
        }
        if (track.getContext() != null) {
            builder.put("context", JsonSerializer.toJsonObject(track.getContext()));
        }
        if (track.getTimestamp() != null) {
            builder.put("timestamp", track.getTimestamp().toString());
        }
        return JsonSerializer.toJsonString(builder);
    }

    public static Track parseTrack(String json) {
        JsonString timestamp;
        JsonObject context;
        JsonObject properties;
        JsonString event;
        JsonObject obj = (JsonObject)JsonReader.of((String)json).read();
        Track track = new Track();
        JsonString userId = (JsonString)obj.get("userId");
        if (userId != null) {
            track.setUserId(userId.value());
        }
        if ((event = (JsonString)obj.get("event")) != null) {
            track.setEvent(TrackEventType.valueOf(event.value()));
        }
        if ((properties = (JsonObject)obj.get("properties")) != null) {
            track.setProperties(JsonSerializer.parseTrackProperties(properties));
        }
        if ((context = (JsonObject)obj.get("context")) != null) {
            track.setContext(JsonSerializer.toMap(context));
        }
        if ((timestamp = (JsonString)obj.get("timestamp")) != null) {
            track.setTimestamp(Instant.parse(timestamp.value()));
        }
        return track;
    }

    private static TrackProperties parseTrackProperties(JsonObject obj) {
        TrackProperties props = new TrackProperties();
        JsonArray appExtensions = (JsonArray)obj.get("app_extensions");
        if (appExtensions != null) {
            ArrayList<TrackProperties.AppExtension> extensions = new ArrayList<TrackProperties.AppExtension>();
            for (JsonValue value : appExtensions.value()) {
                if (!(value instanceof JsonObject)) continue;
                JsonObject extObj = (JsonObject)value;
                extensions.add(JsonSerializer.parseAppExtension(extObj));
            }
            props.setAppExtensions(extensions);
        }
        return props;
    }

    private static TrackProperties.AppExtension parseAppExtension(JsonObject obj) {
        JsonString version;
        JsonString artifactId;
        TrackProperties.AppExtension ext = new TrackProperties.AppExtension();
        JsonString groupId = (JsonString)obj.get("group_id");
        if (groupId != null) {
            ext.setGroupId(groupId.value());
        }
        if ((artifactId = (JsonString)obj.get("artifact_id")) != null) {
            ext.setArtifactId(artifactId.value());
        }
        if ((version = (JsonString)obj.get("version")) != null) {
            ext.setVersion(version.value());
        }
        return ext;
    }

    private static Json.JsonObjectBuilder toJsonObject(TrackProperties props) {
        Json.JsonObjectBuilder builder = Json.object();
        if (props.getAppExtensions() != null) {
            Json.JsonArrayBuilder arrayBuilder = Json.array();
            for (TrackProperties.AppExtension ext : props.getAppExtensions()) {
                arrayBuilder.add(JsonSerializer.toJsonObject(ext));
            }
            builder.put("app_extensions", arrayBuilder);
        }
        return builder;
    }

    private static Json.JsonObjectBuilder toJsonObject(TrackProperties.AppExtension ext) {
        Json.JsonObjectBuilder builder = Json.object();
        if (ext.getGroupId() != null) {
            builder.put("group_id", ext.getGroupId());
        }
        if (ext.getArtifactId() != null) {
            builder.put("artifact_id", ext.getArtifactId());
        }
        if (ext.getVersion() != null) {
            builder.put("version", ext.getVersion());
        }
        return builder;
    }

    private static Json.JsonObjectBuilder toJsonObject(Map<String, Object> map) {
        Json.JsonObjectBuilder builder = Json.object();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                String str = (String)value;
                builder.put(entry.getKey(), str);
                continue;
            }
            if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                builder.put(entry.getKey(), (Object)bool);
                continue;
            }
            if (value instanceof Integer) {
                Integer intVal = (Integer)value;
                builder.put(entry.getKey(), (Object)intVal);
                continue;
            }
            if (value instanceof Long) {
                Long longVal = (Long)value;
                builder.put(entry.getKey(), (Object)longVal);
                continue;
            }
            if (value instanceof Map) {
                builder.put(entry.getKey(), JsonSerializer.toJsonObject((Map)value));
                continue;
            }
            if (value instanceof List) {
                builder.put(entry.getKey(), JsonSerializer.toJsonArrayFromObjects((List)value));
                continue;
            }
            if (value == null) continue;
            builder.put(entry.getKey(), value.toString());
        }
        return builder;
    }

    private static Json.JsonArrayBuilder toJsonArray(List<String> list) {
        Json.JsonArrayBuilder builder = Json.array();
        builder.addAll(list);
        return builder;
    }

    private static Json.JsonArrayBuilder toJsonArrayFromObjects(List<Object> list) {
        Json.JsonArrayBuilder builder = Json.array();
        for (Object item : list) {
            if (item instanceof String) {
                String str = (String)item;
                builder.add(str);
                continue;
            }
            if (item instanceof Boolean) {
                Boolean bool = (Boolean)item;
                builder.add((Object)bool);
                continue;
            }
            if (item instanceof Integer) {
                Integer intVal = (Integer)item;
                builder.add((Object)intVal);
                continue;
            }
            if (item instanceof Long) {
                Long longVal = (Long)item;
                builder.add((Object)longVal);
                continue;
            }
            if (item instanceof Map) {
                builder.add(JsonSerializer.toJsonObject((Map)item));
                continue;
            }
            if (item instanceof List) {
                builder.add(JsonSerializer.toJsonArrayFromObjects((List)item));
                continue;
            }
            if (item == null) continue;
            builder.add(item.toString());
        }
        return builder;
    }

    private static List<String> toStringList(JsonArray array) {
        ArrayList<String> result = new ArrayList<String>();
        for (JsonValue value : array.value()) {
            if (!(value instanceof JsonString)) continue;
            JsonString str = (JsonString)value;
            result.add(str.value());
        }
        return result;
    }

    private static Map<String, Object> toMap(JsonObject obj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (JsonMember member : obj.members()) {
            String key = member.attribute().value();
            JsonValue value = member.value();
            result.put(key, JsonSerializer.toJavaValue(value));
        }
        return result;
    }

    private static Object toJavaValue(JsonValue value) {
        if (value instanceof JsonString) {
            JsonString str = (JsonString)value;
            return str.value();
        }
        if (value instanceof JsonBoolean) {
            JsonBoolean bool = (JsonBoolean)value;
            return bool.value();
        }
        if (value instanceof JsonInteger) {
            JsonInteger intVal = (JsonInteger)value;
            return intVal.longValue();
        }
        if (value instanceof JsonObject) {
            JsonObject obj = (JsonObject)value;
            return JsonSerializer.toMap(obj);
        }
        if (value instanceof JsonArray) {
            JsonArray arr = (JsonArray)value;
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonValue item : arr.value()) {
                list.add(JsonSerializer.toJavaValue(item));
            }
            return list;
        }
        return null;
    }

    private static String toJsonString(Json.JsonObjectBuilder builder) {
        StringBuilder sb = new StringBuilder();
        try {
            builder.appendTo((Appendable)sb);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize JSON", e);
        }
        return sb.toString();
    }

    public static Identity parseIdentity(String json) {
        JsonString timestamp;
        JsonObject ctx;
        JsonObject obj = (JsonObject)JsonReader.of((String)json).read();
        Identity.IdentityBuilder builder = Identity.builder();
        JsonString userId = (JsonString)obj.get("userId");
        if (userId != null) {
            builder.userId(userId.value());
        }
        if ((ctx = (JsonObject)obj.get("context")) != null) {
            builder.context(JsonSerializer.toMap(ctx));
        }
        if ((timestamp = (JsonString)obj.get("timestamp")) != null) {
            builder.timestamp(Instant.parse(timestamp.value()));
        }
        return builder.build();
    }
}

