/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.analytics.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.analytics.util.StringUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;

public class FileUtils {
    public static void createFileAndParent(Path path) throws IOException {
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
    }

    public static void append(String content, Path path) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.append(content);
        }
    }

    public static <T> void write(T content, Path path) throws IOException {
        ObjectMapper mapper = StringUtils.getObjectMapper();
        mapper.writeValue(path.toFile(), content);
    }

    public static <T> void overwrite(T content, Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
        }
        FileUtils.createFileAndParent(path);
        ObjectMapper mapper = StringUtils.getObjectMapper();
        mapper.writeValue(path.toFile(), content);
    }

    public static <T> Optional<T> read(Class<T> clazz, Path path, MessageWriter log) throws IOException {
        try {
            ObjectMapper mapper = StringUtils.getObjectMapper();
            return Optional.of(mapper.readValue(path.toFile(), clazz));
        }
        catch (Exception e) {
            log.warn("[Quarkus build analytics] Could not read {}", new Object[]{path.toString(), e});
            return Optional.empty();
        }
        catch (Throwable t) {
            log.error("[Quarkus build analytics] Unexpected error reading class " + t.getClass().getName() + " from path: " + path.toString() + ". Got message: " + t.getMessage() + ". Attempting to continue...");
            return Optional.empty();
        }
    }
}

