/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.smallrye.common.constraint.Assert;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerProvider;

public class MojoLogger
implements LoggerProvider {
    static final Object[] NO_PARAMS = new Object[0];
    public static volatile Log delegate;

    public Logger getLogger(final String name) {
        return new Logger(name){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected void doLog(Logger.Level level, String loggerClassName, Object message, Object[] parameters, Throwable thrown) {
                String text;
                Log log = delegate;
                if (log == null) return;
                if (parameters == null || parameters.length == 0) {
                    text = String.valueOf(message);
                } else {
                    try {
                        text = MessageFormat.format(String.valueOf(message), parameters);
                    }
                    catch (Exception e) {
                        text = MojoLogger.this.invalidFormat(String.valueOf(message), parameters);
                    }
                }
                Class<MojoLogger> clazz = MojoLogger.class;
                synchronized (MojoLogger.class) {
                    this.doActualLog(log, level, text, thrown);
                    // ** MonitorExit[var8_9] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected void doLogf(Logger.Level level, String loggerClassName, String format, Object[] parameters, Throwable thrown) {
                String text;
                Log log = delegate;
                if (log == null) return;
                if (parameters == null) {
                    try {
                        text = String.format(format, new Object[0]);
                    }
                    catch (Exception e) {
                        text = MojoLogger.this.invalidFormat(format, NO_PARAMS);
                    }
                } else {
                    try {
                        text = String.format(format, parameters);
                    }
                    catch (Exception e) {
                        text = MojoLogger.this.invalidFormat(format, parameters);
                    }
                }
                if (text.startsWith("JBoss Threads version")) return;
                Class<MojoLogger> clazz = MojoLogger.class;
                synchronized (MojoLogger.class) {
                    this.doActualLog(log, level, text, thrown);
                    // ** MonitorExit[var8_10] (shouldn't be in output)
                    return;
                }
            }

            public boolean isEnabled(Logger.Level level) {
                Log log = delegate;
                if (log == null) {
                    return false;
                }
                switch (level) {
                    case FATAL: 
                    case ERROR: {
                        return log.isErrorEnabled();
                    }
                    case WARN: {
                        return log.isWarnEnabled();
                    }
                    case INFO: {
                        return log.isInfoEnabled();
                    }
                }
                return log.isDebugEnabled();
            }

            void doActualLog(Log log, Logger.Level level, String message, Throwable thrown) {
                MessageBuilder buffer = MessageUtils.buffer();
                if (Logger.Level.DEBUG.compareTo((Enum)level) <= 0) {
                    buffer.strong((Object)"[").project((Object)name).strong((Object)"]").a((CharSequence)" ").a((CharSequence)"(").a((CharSequence)Thread.currentThread().getName()).a((CharSequence)")").a((CharSequence)" ").a((CharSequence)message);
                } else {
                    buffer.strong((Object)"[").project((Object)name).strong((Object)"]").a((CharSequence)" ").a((CharSequence)message);
                }
                if (thrown != null) {
                    switch (level) {
                        case FATAL: 
                        case ERROR: {
                            log.error((CharSequence)buffer.toString(), thrown);
                            break;
                        }
                        case WARN: {
                            log.warn((CharSequence)buffer.toString(), thrown);
                            break;
                        }
                        case INFO: {
                            log.info((CharSequence)buffer.toString(), thrown);
                            break;
                        }
                        default: {
                            log.debug((CharSequence)buffer.toString(), thrown);
                            break;
                        }
                    }
                } else {
                    switch (level) {
                        case FATAL: 
                        case ERROR: {
                            log.error((CharSequence)buffer.toString());
                            break;
                        }
                        case WARN: {
                            log.warn((CharSequence)buffer.toString());
                            break;
                        }
                        case INFO: {
                            log.info((CharSequence)buffer.toString());
                            break;
                        }
                        default: {
                            log.debug((CharSequence)buffer.toString());
                        }
                    }
                }
            }
        };
    }

    String invalidFormat(String format, Object[] parameters) {
        StringBuilder b = new StringBuilder("** invalid format '" + format + "'");
        if (parameters != null && parameters.length > 0) {
            b.append(" [").append(parameters[0]);
            for (int i = 1; i < parameters.length; ++i) {
                b.append(',').append(parameters[i]);
            }
            b.append("]");
        }
        return b.toString();
    }

    public void clearMdc() {
    }

    public Object putMdc(String key, Object value) {
        return null;
    }

    public Object getMdc(String key) {
        return null;
    }

    public void removeMdc(String key) {
    }

    public Map<String, Object> getMdcMap() {
        return Collections.emptyMap();
    }

    public void clearNdc() {
    }

    public String getNdc() {
        return "";
    }

    public int getNdcDepth() {
        return 0;
    }

    public String popNdc() {
        return "";
    }

    public String peekNdc() {
        return "";
    }

    public void pushNdc(String message) {
        throw Assert.unsupported();
    }

    public void setNdcMaxDepth(int maxDepth) {
    }
}

