/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.maven.dependency.ArtifactDependency;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.project.MavenProject;

public enum ImageBuilder {
    docker,
    jib,
    buildpack,
    openshift;

    static final String QUARKUS_PREFIX = "quarkus-";
    static final String QUARKUS_CONTAINER_IMAGE_PREFIX = "quarkus-container-image-";

    public Optional<ArtifactDependency> getExtensionArtifact(MavenProject project) {
        String artifactId = QUARKUS_CONTAINER_IMAGE_PREFIX + this.name();
        return project.getDependencyManagement().getDependencies().stream().filter(d -> "io.quarkus".equals(d.getGroupId()) && artifactId.equals(d.getArtifactId())).map(d -> new ArtifactDependency(d.getGroupId(), d.getArtifactId(), null, "jar", d.getVersion())).findFirst();
    }

    public static Optional<ImageBuilder> getBuilder(String name, MavenProject project) {
        return Optional.ofNullable(name).filter(n -> Arrays.stream(ImageBuilder.values()).map(Enum::name).anyMatch(i -> i.equals(n))).or(() -> ImageBuilder.getProjectBuilder(project).stream().findFirst()).map(ImageBuilder::valueOf);
    }

    public static Optional<ImageBuilder> getBuilder(String name, Collection<ImageBuilder> projectBuilders) {
        return Optional.ofNullable(name).filter(n -> Arrays.stream(ImageBuilder.values()).map(Enum::name).anyMatch(i -> i.equals(n))).map(ImageBuilder::valueOf).or(() -> projectBuilders.stream().findFirst());
    }

    public static Set<String> getProjectBuilder(MavenProject project) {
        return project.getDependencies().stream().filter(d -> "io.quarkus".equals(d.getGroupId())).map(d -> ImageBuilder.strip(d.getArtifactId())).filter(n -> Arrays.stream(ImageBuilder.values()).anyMatch(e -> e.equals(n))).collect(Collectors.toSet());
    }

    private static final String strip(String s) {
        return s.replaceAll("^" + Pattern.quote(QUARKUS_CONTAINER_IMAGE_PREFIX), "").replaceAll("^" + Pattern.quote(QUARKUS_PREFIX), "");
    }
}

