/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.vertx;

import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public class PushedHttpServerRequest
extends HttpServerRequestInternal
implements HttpServerRequest {
    private final HttpServerRequestInternal original;
    private final HttpMethod method;
    private final String uri;
    private final HttpServerResponse response;
    private final MultiMap headers;
    private MultiMap params;
    private String path;
    private String query;
    private String absoluteURI;

    public PushedHttpServerRequest(HttpServerRequest original, HttpMethod method, String uri, HttpServerResponse response, MultiMap headers) {
        this.original = (HttpServerRequestInternal)original;
        this.method = method;
        this.uri = uri;
        this.response = response;
        this.headers = headers;
    }

    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        return this;
    }

    public HttpServerRequest handler(Handler<Buffer> handler) {
        return this;
    }

    public HttpServerRequest pause() {
        return this;
    }

    public HttpServerRequest resume() {
        return this;
    }

    public HttpServerRequest fetch(long amount) {
        return this;
    }

    public HttpServerRequest endHandler(Handler<Void> endHandler) {
        endHandler.handle(null);
        return this;
    }

    public HttpVersion version() {
        return HttpVersion.HTTP_2;
    }

    public HttpMethod method() {
        return this.method;
    }

    public boolean isSSL() {
        return this.original.isSSL();
    }

    public String scheme() {
        return this.original.scheme();
    }

    public String uri() {
        return this.uri;
    }

    public String path() {
        if (this.path == null) {
            this.path = PushedHttpServerRequest.parsePath(this.uri());
        }
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String query() {
        HttpConnection httpConnection = this.original.connection();
        synchronized (httpConnection) {
            this.query = this.uri != null ? PushedHttpServerRequest.parseQuery(this.uri) : null;
            return this.query;
        }
    }

    public String host() {
        return this.original.host();
    }

    public long bytesRead() {
        return 0L;
    }

    public HttpServerResponse response() {
        return this.response;
    }

    public MultiMap headers() {
        return this.headers;
    }

    public String getHeader(String headerName) {
        return this.headers.get(headerName);
    }

    public String getHeader(CharSequence headerName) {
        return this.headers.get(headerName);
    }

    public HttpServerRequest setParamsCharset(String charset) {
        return this.original.setParamsCharset(charset);
    }

    public String getParamsCharset() {
        return this.original.getParamsCharset();
    }

    public MultiMap params() {
        if (this.params == null) {
            this.params = PushedHttpServerRequest.params(this.uri());
        }
        return this.params;
    }

    public String getParam(String paramName) {
        return this.params().get(paramName);
    }

    public SocketAddress remoteAddress() {
        return this.original.remoteAddress();
    }

    public SocketAddress localAddress() {
        return this.original.localAddress();
    }

    public SSLSession sslSession() {
        return this.original.sslSession();
    }

    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.original.peerCertificateChain();
    }

    public String absoluteURI() {
        if (this.absoluteURI == null) {
            try {
                this.absoluteURI = PushedHttpServerRequest.absoluteURI(this.original.host(), this);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return this.absoluteURI;
    }

    public Future<Buffer> body() {
        return this.original.body();
    }

    public Future<Void> end() {
        return null;
    }

    public Future<NetSocket> toNetSocket() {
        return this.original.toNetSocket();
    }

    public HttpServerRequest setExpectMultipart(boolean expect) {
        return this;
    }

    public boolean isExpectMultipart() {
        return false;
    }

    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> uploadHandler) {
        return this;
    }

    public MultiMap formAttributes() {
        return this.original.formAttributes();
    }

    public String getFormAttribute(String attributeName) {
        return this.original.getFormAttribute(attributeName);
    }

    public Future<ServerWebSocket> toWebSocket() {
        throw new UnsupportedOperationException();
    }

    public boolean isEnded() {
        return true;
    }

    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        return this;
    }

    public HttpConnection connection() {
        return this.original.connection();
    }

    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        return this;
    }

    public Cookie getCookie(String name) {
        return this.original.getCookie(name);
    }

    public int cookieCount() {
        return this.original.cookieCount();
    }

    public Map<String, Cookie> cookieMap() {
        return this.original.cookieMap();
    }

    public Cookie getCookie(String name, String domain, String path) {
        return this.original.getCookie(name, domain, path);
    }

    public Set<Cookie> cookies(String name) {
        return this.original.cookies(name);
    }

    public Set<Cookie> cookies() {
        return this.original.cookies();
    }

    static String parsePath(String uri) {
        int i;
        if (uri.charAt(0) == '/') {
            i = 0;
        } else {
            i = uri.indexOf("://");
            if (i == -1) {
                i = 0;
            } else if ((i = uri.indexOf(47, i + 3)) == -1) {
                return "/";
            }
        }
        int queryStart = uri.indexOf(63, i);
        if (queryStart == -1) {
            queryStart = uri.length();
        }
        return uri.substring(i, queryStart);
    }

    static String parseQuery(String uri) {
        int i = uri.indexOf(63);
        if (i == -1) {
            return null;
        }
        return uri.substring(i + 1, uri.length());
    }

    static String absoluteURI(String serverOrigin, HttpServerRequest req) throws URISyntaxException {
        String host;
        URI uri = new URI(req.uri());
        String scheme = uri.getScheme();
        Object absoluteURI = scheme != null && (scheme.equals("http") || scheme.equals("https")) ? uri.toString() : ((host = req.host()) != null ? req.scheme() + "://" + host + String.valueOf(uri) : serverOrigin + String.valueOf(uri));
        return absoluteURI;
    }

    static MultiMap params(String uri) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(uri);
        Map prms = queryStringDecoder.parameters();
        MultiMap params = MultiMap.caseInsensitiveMultiMap();
        if (!prms.isEmpty()) {
            for (Map.Entry entry : prms.entrySet()) {
                params.add((String)entry.getKey(), (Iterable)entry.getValue());
            }
        }
        return params;
    }

    public String getParam(String paramName, String defaultValue) {
        return this.original.getParam(paramName, defaultValue);
    }

    public HttpServerRequest bodyHandler(Handler<Buffer> bodyHandler) {
        return this.original.bodyHandler(bodyHandler);
    }

    public HttpServerRequest body(Handler<AsyncResult<Buffer>> handler) {
        return this.original.body(handler);
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.original.end(handler);
    }

    public void toNetSocket(Handler<AsyncResult<NetSocket>> handler) {
        this.original.toNetSocket(handler);
    }

    public int streamId() {
        return this.original.streamId();
    }

    public void toWebSocket(Handler<AsyncResult<ServerWebSocket>> handler) {
        this.original.toWebSocket(handler);
    }

    public StreamPriority streamPriority() {
        return this.original.streamPriority();
    }

    public DecoderResult decoderResult() {
        return this.original.decoderResult();
    }

    public HttpServerRequest routed(String route) {
        return this.original.routed(route);
    }

    public Context context() {
        return this.original.context();
    }

    public Object metric() {
        return this.original.metric();
    }

    public HostAndPort authority() {
        return this.original.authority();
    }

    public MultiMap params(boolean semicolonIsNormalChar) {
        return this.original.params(semicolonIsNormalChar);
    }
}

