/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import jakarta.servlet.DispatcherType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DispatcherTypePredicate
implements Predicate {
    public static final DispatcherTypePredicate FORWARD = new DispatcherTypePredicate(DispatcherType.FORWARD);
    public static final DispatcherTypePredicate INCLUDE = new DispatcherTypePredicate(DispatcherType.INCLUDE);
    public static final DispatcherTypePredicate REQUEST = new DispatcherTypePredicate(DispatcherType.REQUEST);
    public static final DispatcherTypePredicate ASYNC = new DispatcherTypePredicate(DispatcherType.ASYNC);
    public static final DispatcherTypePredicate ERROR = new DispatcherTypePredicate(DispatcherType.ERROR);
    private final DispatcherType dispatcherType;

    public DispatcherTypePredicate(DispatcherType dispatcherType) {
        this.dispatcherType = dispatcherType;
    }

    public boolean resolve(HttpServerExchange value) {
        return ((ServletRequestContext)value.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getDispatcherType() == this.dispatcherType;
    }

    public static class Builder
    implements PredicateBuilder {
        public String name() {
            return "dispatcher";
        }

        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("value", String.class);
            return params;
        }

        public Set<String> requiredParameters() {
            HashSet<String> params = new HashSet<String>();
            params.add("value");
            return params;
        }

        public String defaultParameter() {
            return "value";
        }

        public Predicate build(Map<String, Object> config) {
            String value = (String)config.get("value");
            return new DispatcherTypePredicate(DispatcherType.valueOf((String)value));
        }
    }
}

