/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.classfile.CodeBuilder;
import io.smallrye.classfile.Label;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

final class TryCatch
extends Item {
    private final BlockCreatorImpl body;
    private List<Catch> catches = List.of();

    TryCatch(BlockCreatorImpl body) {
        this.body = body;
    }

    @Override
    public boolean mayFallThrough() {
        return this.body.mayFallThrough() || this.catches.stream().map(Catch::body).anyMatch(BlockCreatorImpl::mayFallThrough);
    }

    BlockCreatorImpl addCatch(ClassDesc superType, Set<ClassDesc> types) {
        BlockCreatorImpl bci = new BlockCreatorImpl(this.body.parent(), superType);
        bci.branchTarget();
        Catch catch_ = new Catch(superType, types, bci);
        List<Catch> list = this.catches;
        if (list instanceof ArrayList) {
            ArrayList al = (ArrayList)list;
            al.add(catch_);
        } else {
            this.catches = Util.listWith(this.catches, catch_);
        }
        return bci;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        Label after = cb.newLabel();
        StackMapBuilder.Saved saved = smb.save();
        this.body.writeCode(cb, block, smb);
        smb.restore(saved);
        boolean afterFrameInfo = false;
        if (this.body.mayFallThrough()) {
            cb.goto_(after);
            smb.wroteCode();
            afterFrameInfo = true;
        }
        for (Catch catch_ : this.catches) {
            BlockCreatorImpl catchBody = catch_.body();
            smb.push(catch_.superType());
            catchBody.writeCode(cb, block, smb);
            smb.restore(saved);
            if (catchBody.mayFallThrough()) {
                cb.goto_(after);
                afterFrameInfo = true;
                smb.wroteCode();
            }
            for (ClassDesc type : catch_.types()) {
                if (Util.equals(type, ConstantDescs.CD_Throwable)) {
                    cb.exceptionCatchAll(this.body.startLabel(), this.body.endLabel(), catchBody.startLabel());
                    continue;
                }
                cb.exceptionCatch(this.body.startLabel(), this.body.endLabel(), catchBody.startLabel(), type);
            }
        }
        cb.labelBinding(after);
        if (afterFrameInfo) {
            smb.addFrameInfo(cb);
        }
    }

    record Catch(ClassDesc superType, Set<ClassDesc> types, BlockCreatorImpl body) {
    }
}

