/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Conversions;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.constant.IntConst;
import io.smallrye.classfile.CodeBuilder;
import io.smallrye.classfile.TypeKind;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.invoke.TypeDescriptor;
import java.util.ListIterator;
import java.util.function.BiConsumer;

final class NewEmptyArray
extends Item {
    private final Item size;

    NewEmptyArray(ClassDesc componentType, Item size) {
        super(componentType.arrayType());
        this.size = Conversions.convert(size, ConstantDescs.CD_int);
    }

    @Override
    public String itemName() {
        return "NewEmptyArray:" + this.type().displayName();
    }

    @Override
    protected void forEachDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
        this.size.process(itr, op);
    }

    @Override
    public Expr length() {
        return this.size instanceof IntConst ? this.size : super.length();
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        ClassDesc componentType = this.type().componentType();
        TypeKind typeKind = TypeKind.from((TypeDescriptor.OfField)componentType);
        if (typeKind == TypeKind.REFERENCE) {
            cb.anewarray(componentType);
        } else {
            cb.newarray(typeKind);
        }
        smb.pop();
        smb.push(this.type());
        smb.wroteCode();
    }
}

