/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import io.quarkus.gizmo2.impl.StaticFieldVarImpl;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.function.BiFunction;

final class StaticFieldGetViaHandle
extends Item {
    private final StaticFieldVarImpl staticFieldVar;
    private final MemoryOrder mode;

    StaticFieldGetViaHandle(StaticFieldVarImpl staticFieldVar, MemoryOrder mode) {
        super(staticFieldVar.type(), staticFieldVar.hasGenericType() ? staticFieldVar.genericType() : null);
        this.staticFieldVar = staticFieldVar;
        this.mode = mode;
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return ConstImpl.ofStaticFieldVarHandle(this.staticFieldVar.desc()).process(node.prev(), op);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        cb.invokevirtual(ConstantDescs.CD_VarHandle, switch (this.mode) {
            case MemoryOrder.Plain -> "get";
            case MemoryOrder.Opaque -> "getOpaque";
            case MemoryOrder.Acquire -> "getAcquire";
            case MemoryOrder.Volatile -> "getVolatile";
            default -> throw Assert.impossibleSwitchCase((Object)((Object)this.mode));
        }, MethodTypeDesc.of(this.type(), new ClassDesc[0]));
    }
}

