/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Label;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.If;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import io.quarkus.gizmo2.impl.Preconditions;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ConstantDescs;
import java.util.function.BiFunction;

final class Rel
extends Item {
    private final Item a;
    private final Item b;
    private final If.Kind kind;

    Rel(Expr a, Expr b, If.Kind kind) {
        super(ConstantDescs.CD_boolean);
        this.kind = kind;
        Preconditions.requireSameTypeKind(a, b);
        this.a = (Item)a;
        this.b = (Item)b;
        if (a.typeKind() == TypeKind.REFERENCE) {
            if (kind.if_acmp == null) {
                throw new IllegalStateException("Invalid comparison for reference types");
            }
        } else if (a.typeKind().asLoadable() != TypeKind.INT) {
            throw new UnsupportedOperationException("Only supported on int and reference types");
        }
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return this.a.process(this.b.process(node.prev(), op), op);
    }

    Item left() {
        return this.a;
    }

    Item right() {
        return this.b;
    }

    If.Kind kind() {
        return this.kind;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        Label true_ = cb.newLabel();
        Label end = cb.newLabel();
        switch (this.a.typeKind().asLoadable()) {
            case INT: {
                this.kind.if_icmp.accept(cb, true_);
                break;
            }
            case REFERENCE: {
                this.kind.if_acmp.accept(cb, true_);
                break;
            }
            default: {
                throw Assert.impossibleSwitchCase((Object)((Object)this.typeKind().asLoadable()));
            }
        }
        cb.iconst_0();
        cb.goto_(end);
        cb.labelBinding(true_);
        cb.iconst_1();
        cb.labelBinding(end);
    }
}

