/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Conversions;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.Optional;
import java.util.function.BiFunction;

final class Cmp
extends Item {
    static final ClassDesc CD_Comparable = Util.classDesc(Comparable.class);
    private final Item a;
    private final Item b;
    private final Kind kind;

    Cmp(Expr a, Expr b, Kind kind) {
        super(ConstantDescs.CD_int);
        Optional<ClassDesc> promotedType = Conversions.numericPromotion(a.type(), b.type());
        if (promotedType.isPresent()) {
            this.a = Conversions.convert(a, promotedType.get());
            this.b = Conversions.convert(b, promotedType.get());
        } else {
            if (TypeKind.from(a.type()) != TypeKind.REFERENCE || TypeKind.from(b.type()) != TypeKind.REFERENCE) {
                throw new IllegalArgumentException("Comparison expects both operands to have the same type: " + a.type().displayName() + ", " + b.type().displayName());
            }
            this.a = (Item)a;
            this.b = (Item)b;
        }
        this.kind = kind;
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return this.a.process(this.b.process(node.prev(), op), op);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        switch (this.a.typeKind().asLoadable()) {
            case INT: {
                this.kind.intOp.apply(cb);
                break;
            }
            case LONG: {
                this.kind.longOp.apply(cb);
                break;
            }
            case FLOAT: {
                this.kind.floatOp.apply(cb);
                break;
            }
            case DOUBLE: {
                this.kind.doubleOp.apply(cb);
                break;
            }
            case REFERENCE: {
                this.kind.refOp.apply(cb);
                break;
            }
            default: {
                throw Assert.impossibleSwitchCase((Object)((Object)this.a.typeKind().asLoadable()));
            }
        }
    }

    private static void acmp(CodeBuilder cb) {
        cb.invokeinterface(CD_Comparable, "compareTo", MethodTypeDesc.of(ConstantDescs.CD_int, ConstantDescs.CD_Object));
    }

    private static void icmp(CodeBuilder cb) {
        cb.invokestatic(ConstantDescs.CD_Integer, "compare", MethodTypeDesc.of(ConstantDescs.CD_int, ConstantDescs.CD_int, ConstantDescs.CD_int));
    }

    private static void dcmp(CodeBuilder cb) {
        cb.invokestatic(ConstantDescs.CD_Double, "compare", MethodTypeDesc.of(ConstantDescs.CD_int, ConstantDescs.CD_double, ConstantDescs.CD_double));
    }

    private static void fcmp(CodeBuilder cb) {
        cb.invokestatic(ConstantDescs.CD_Float, "compare", MethodTypeDesc.of(ConstantDescs.CD_int, ConstantDescs.CD_float, ConstantDescs.CD_float));
    }

    static enum Kind {
        CMP(Cmp::icmp, CodeBuilder::lcmp, Cmp::fcmp, Cmp::dcmp, Cmp::acmp),
        CMPG(Cmp::icmp, CodeBuilder::lcmp, CodeBuilder::fcmpg, CodeBuilder::dcmpg, Cmp::acmp),
        CMPL(Cmp::icmp, CodeBuilder::lcmp, CodeBuilder::fcmpl, CodeBuilder::dcmpl, Cmp::acmp);

        final CmpOp intOp;
        final CmpOp longOp;
        final CmpOp floatOp;
        final CmpOp doubleOp;
        final CmpOp refOp;

        private Kind(CmpOp intOp, CmpOp longOp, CmpOp floatOp, CmpOp doubleOp, CmpOp refOp) {
            this.doubleOp = doubleOp;
            this.floatOp = floatOp;
            this.intOp = intOp;
            this.longOp = longOp;
            this.refOp = refOp;
        }
    }

    static interface CmpOp {
        public void apply(CodeBuilder var1);
    }
}

