/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Opcode;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Cast;
import io.quarkus.gizmo2.impl.Conversions;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;

final class Box
extends Cast {
    private static ClassDesc boxing(ClassDesc unboxType) {
        ClassDesc boxType = Conversions.boxingConversion(unboxType).orElseThrow(() -> new IllegalArgumentException("No box type for " + unboxType.displayName()));
        if (boxType.equals(ConstantDescs.CD_Void)) {
            throw new IllegalArgumentException("Cannot box void");
        }
        return boxType;
    }

    Box(Expr a) {
        this(a, Box.boxing(a.type()));
    }

    Box(Expr a, ClassDesc toType) {
        super(a, toType, null);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        ClassDesc boxType = Box.boxing(this.a.type());
        cb.invoke(Opcode.INVOKESTATIC, boxType, "valueOf", MethodTypeDesc.of(boxType, this.a.type()), false);
    }
}

