/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.desc;

import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.InterfaceMethodDescImpl;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.MethodType;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface InterfaceMethodDesc
extends MethodDesc {
    public static InterfaceMethodDesc of(ClassDesc owner, String name, MethodTypeDesc type) {
        return new InterfaceMethodDescImpl(owner, name, type);
    }

    public static InterfaceMethodDesc of(ClassDesc owner, String name, MethodType type) {
        return InterfaceMethodDesc.of(owner, name, type.describeConstable().orElseThrow(IllegalArgumentException::new));
    }

    public static InterfaceMethodDesc of(ClassDesc owner, String name, Class<?> returnType, Class<?> ... paramTypes) {
        return InterfaceMethodDesc.of(owner, name, MethodType.methodType(returnType, paramTypes));
    }

    public static InterfaceMethodDesc of(ClassDesc owner, String name, Class<?> returnType, List<Class<?>> paramTypes) {
        return InterfaceMethodDesc.of(owner, name, MethodType.methodType(returnType, paramTypes));
    }

    public static InterfaceMethodDesc of(ClassDesc owner, String name, ClassDesc returnType, ClassDesc ... paramTypes) {
        return InterfaceMethodDesc.of(owner, name, MethodTypeDesc.of(returnType, paramTypes));
    }

    public static InterfaceMethodDesc of(ClassDesc owner, String name, ClassDesc returnType, List<ClassDesc> paramTypes) {
        return InterfaceMethodDesc.of(owner, name, MethodTypeDesc.of(returnType, (ClassDesc[])paramTypes.toArray(ClassDesc[]::new)));
    }
}

