/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.InvocationTransformerKind;

final class InvocationTransformer {
    final InvocationTransformerKind kind;
    final Class<?> clazz;
    final String method;

    InvocationTransformer(InvocationTransformerKind kind, Class<?> clazz, String method) {
        this.kind = kind;
        this.clazz = clazz;
        this.method = method;
    }

    public String toString() {
        String kind = switch (this.kind) {
            default -> throw new IncompatibleClassChangeError();
            case InvocationTransformerKind.INSTANCE -> "target instance transformer ";
            case InvocationTransformerKind.ARGUMENT -> "argument transformer ";
            case InvocationTransformerKind.RETURN_VALUE -> "return value transformer ";
            case InvocationTransformerKind.EXCEPTION -> "exception transformer ";
            case InvocationTransformerKind.WRAPPER -> "invocation wrapper ";
        };
        return kind + this.clazz.getName() + "." + this.method + "()";
    }

    public boolean isInputTransformer() {
        return this.kind == InvocationTransformerKind.INSTANCE || this.kind == InvocationTransformerKind.ARGUMENT;
    }

    public boolean isOutputTransformer() {
        return this.kind == InvocationTransformerKind.RETURN_VALUE || this.kind == InvocationTransformerKind.EXCEPTION;
    }
}

