/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.AnnotationsOverlay;
import io.quarkus.arc.processor.bcextensions.ClassInfoImpl;
import io.quarkus.arc.processor.bcextensions.DeclarationInfoImpl;
import io.quarkus.arc.processor.bcextensions.MethodPredicates;
import io.quarkus.arc.processor.bcextensions.ParameterInfoImpl;
import io.quarkus.arc.processor.bcextensions.TypeImpl;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.declarations.ParameterInfo;
import jakarta.enterprise.lang.model.types.TypeVariable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;

class MethodInfoImpl
extends DeclarationInfoImpl<org.jboss.jandex.MethodInfo>
implements MethodInfo {
    private final DotName className;
    private final String name;
    private final List<Type> parameterTypes;

    MethodInfoImpl(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays, org.jboss.jandex.MethodInfo jandexDeclaration) {
        super(jandexIndex, annotationOverlays, jandexDeclaration);
        this.className = jandexDeclaration.declaringClass().name();
        this.name = jandexDeclaration.name();
        this.parameterTypes = jandexDeclaration.parameterTypes();
    }

    public String name() {
        if (this.isConstructor()) {
            return ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).declaringClass().name().toString();
        }
        return ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).name();
    }

    public List<ParameterInfo> parameters() {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(((org.jboss.jandex.MethodInfo)this.jandexDeclaration).parametersCount());
        for (MethodParameterInfo jandexParameter : ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).parameters()) {
            result.add(new ParameterInfoImpl(this.jandexIndex, this.annotationOverlays, jandexParameter));
        }
        return result;
    }

    public jakarta.enterprise.lang.model.types.Type returnType() {
        if (this.isConstructor()) {
            AnnotationInstance[] typeAnnotations = ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).returnType().annotations().toArray(new AnnotationInstance[0]);
            Type classType = Type.createWithAnnotations((DotName)((org.jboss.jandex.MethodInfo)this.jandexDeclaration).declaringClass().name(), (Type.Kind)Type.Kind.CLASS, (AnnotationInstance[])typeAnnotations);
            return TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlays, classType);
        }
        return TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlays, ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).returnType());
    }

    public jakarta.enterprise.lang.model.types.Type receiverType() {
        if (Modifier.isStatic(((org.jboss.jandex.MethodInfo)this.jandexDeclaration).flags())) {
            return null;
        }
        if (MethodPredicates.IS_CONSTRUCTOR_JANDEX.test((org.jboss.jandex.MethodInfo)this.jandexDeclaration)) {
            org.jboss.jandex.ClassInfo declaringClass = ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).declaringClass();
            ClassInfo.NestingType nestingType = declaringClass.nestingType();
            if (nestingType == ClassInfo.NestingType.TOP_LEVEL) {
                return null;
            }
            if (nestingType == ClassInfo.NestingType.INNER && Modifier.isStatic(declaringClass.flags())) {
                return null;
            }
        }
        return TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlays, ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).receiverType());
    }

    public List<jakarta.enterprise.lang.model.types.Type> throwsTypes() {
        return ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).exceptions().stream().map(it -> TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlays, it)).collect(Collectors.toUnmodifiableList());
    }

    public List<TypeVariable> typeParameters() {
        return ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).typeParameters().stream().map(it -> TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlays, (Type)it)).filter(jakarta.enterprise.lang.model.types.Type::isTypeVariable).map(jakarta.enterprise.lang.model.types.Type::asTypeVariable).collect(Collectors.toUnmodifiableList());
    }

    public boolean isConstructor() {
        return MethodPredicates.IS_CONSTRUCTOR_JANDEX.test((org.jboss.jandex.MethodInfo)this.jandexDeclaration);
    }

    public boolean isStatic() {
        return Modifier.isStatic(((org.jboss.jandex.MethodInfo)this.jandexDeclaration).flags());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(((org.jboss.jandex.MethodInfo)this.jandexDeclaration).flags());
    }

    public boolean isFinal() {
        return Modifier.isFinal(((org.jboss.jandex.MethodInfo)this.jandexDeclaration).flags());
    }

    public int modifiers() {
        return ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).flags();
    }

    public ClassInfo declaringClass() {
        return new ClassInfoImpl(this.jandexIndex, this.annotationOverlays, ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).declaringClass());
    }

    @Override
    AnnotationsOverlay<org.jboss.jandex.MethodInfo> annotationsOverlay() {
        return this.annotationOverlays.methods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodInfoImpl that = (MethodInfoImpl)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.name, that.name) && Objects.equals(this.parameterTypes, that.parameterTypes);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.name, this.parameterTypes);
    }
}

