/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AnnotationSet;
import io.quarkus.arc.processor.bcextensions.DotNames;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.EquivalenceKey;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;

abstract class AnnotationsOverlay<JandexDeclaration extends AnnotationTarget> {
    private final Map<EquivalenceKey, AnnotationSet> overlay = new ConcurrentHashMap<EquivalenceKey, AnnotationSet>();
    private volatile boolean invalid = false;

    AnnotationsOverlay() {
    }

    AnnotationSet getAnnotations(JandexDeclaration jandexDeclaration, IndexView jandexIndex) {
        if (this.invalid) {
            throw new IllegalStateException("Annotations overlay no longer valid");
        }
        EquivalenceKey key = EquivalenceKey.of(jandexDeclaration);
        if (this.overlay.containsKey(key)) {
            return this.overlay.get(key);
        }
        AnnotationSet annotationSet = this.createAnnotationSet(jandexDeclaration, jandexIndex);
        this.overlay.put(key, annotationSet);
        return annotationSet;
    }

    boolean hasAnnotation(JandexDeclaration jandexDeclaration, DotName annotationName, IndexView jandexIndex) {
        if (this.invalid) {
            throw new IllegalStateException("Annotations overlay no longer valid");
        }
        EquivalenceKey key = EquivalenceKey.of(jandexDeclaration);
        boolean hasOverlay = this.overlay.containsKey(key);
        if (hasOverlay) {
            return this.getAnnotations(jandexDeclaration, jandexIndex).hasAnnotation(annotationName);
        }
        return this.originalJandexAnnotationsContain(jandexDeclaration, annotationName, jandexIndex);
    }

    void invalidate() {
        this.overlay.clear();
        this.invalid = true;
    }

    abstract AnnotationSet createAnnotationSet(JandexDeclaration var1, IndexView var2);

    abstract boolean originalJandexAnnotationsContain(JandexDeclaration var1, DotName var2, IndexView var3);

    static class Fields
    extends AnnotationsOverlay<FieldInfo> {
        Fields() {
        }

        @Override
        AnnotationSet createAnnotationSet(FieldInfo fieldInfo, IndexView jandexIndex) {
            List<AnnotationInstance> jandexAnnotations = fieldInfo.declaredAnnotations().stream().filter(AnnotationInstance::runtimeVisible).collect(Collectors.toUnmodifiableList());
            return new AnnotationSet(jandexAnnotations);
        }

        @Override
        boolean originalJandexAnnotationsContain(FieldInfo fieldInfo, DotName annotationName, IndexView jandexIndex) {
            AnnotationInstance jandexAnnotation = fieldInfo.declaredAnnotation(annotationName);
            return jandexAnnotation != null && jandexAnnotation.runtimeVisible();
        }
    }

    static class Parameters
    extends AnnotationsOverlay<MethodParameterInfo> {
        Parameters() {
        }

        @Override
        AnnotationSet createAnnotationSet(MethodParameterInfo methodParameterInfo, IndexView jandexIndex) {
            List<AnnotationInstance> jandexAnnotations = methodParameterInfo.declaredAnnotations().stream().filter(AnnotationInstance::runtimeVisible).collect(Collectors.toUnmodifiableList());
            return new AnnotationSet(jandexAnnotations);
        }

        @Override
        boolean originalJandexAnnotationsContain(MethodParameterInfo methodParameterInfo, DotName annotationName, IndexView jandexIndex) {
            AnnotationInstance jandexAnnotation = methodParameterInfo.declaredAnnotation(annotationName);
            return jandexAnnotation != null && jandexAnnotation.runtimeVisible();
        }
    }

    static class Methods
    extends AnnotationsOverlay<MethodInfo> {
        Methods() {
        }

        @Override
        AnnotationSet createAnnotationSet(MethodInfo methodInfo, IndexView jandexIndex) {
            List<AnnotationInstance> jandexAnnotations = methodInfo.declaredAnnotations().stream().filter(AnnotationInstance::runtimeVisible).collect(Collectors.toUnmodifiableList());
            return new AnnotationSet(jandexAnnotations);
        }

        @Override
        boolean originalJandexAnnotationsContain(MethodInfo methodInfo, DotName annotationName, IndexView jandexIndex) {
            AnnotationInstance jandexAnnotation = methodInfo.declaredAnnotation(annotationName);
            return jandexAnnotation != null && jandexAnnotation.runtimeVisible();
        }
    }

    static class Classes
    extends AnnotationsOverlay<ClassInfo> {
        Classes() {
        }

        @Override
        AnnotationSet createAnnotationSet(ClassInfo classInfo, IndexView jandexIndex) {
            HashSet<DotName> alreadySeen = new HashSet<DotName>();
            ArrayList<AnnotationInstance> jandexAnnotations = new ArrayList<AnnotationInstance>();
            ConcurrentHashMap<DotName, Integer> inheritanceDistances = new ConcurrentHashMap<DotName, Integer>();
            int currentDistance = 0;
            while (classInfo != null && !classInfo.name().equals((Object)DotNames.OBJECT)) {
                for (AnnotationInstance jandexAnnotation : classInfo.declaredAnnotations()) {
                    if (!jandexAnnotation.runtimeVisible() || alreadySeen.contains(jandexAnnotation.name())) continue;
                    alreadySeen.add(jandexAnnotation.name());
                    jandexAnnotations.add(jandexAnnotation);
                    inheritanceDistances.put(jandexAnnotation.name(), currentDistance);
                }
                DotName superClassName = classInfo.superName();
                classInfo = jandexIndex.getClassByName(superClassName);
                ++currentDistance;
            }
            return new AnnotationSet(jandexAnnotations, inheritanceDistances);
        }

        @Override
        boolean originalJandexAnnotationsContain(ClassInfo classInfo, DotName annotationName, IndexView jandexIndex) {
            while (classInfo != null && !classInfo.name().equals((Object)DotNames.OBJECT)) {
                AnnotationInstance jandexAnnotation = classInfo.declaredAnnotation(annotationName);
                if (jandexAnnotation != null && jandexAnnotation.runtimeVisible()) {
                    return true;
                }
                DotName superClassName = classInfo.superName();
                classInfo = jandexIndex.getClassByName(superClassName);
            }
            return false;
        }
    }
}

