/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public final class Annotations {
    private Annotations() {
    }

    public static AnnotationInstance find(Collection<AnnotationInstance> annotations, DotName name) {
        if (annotations.isEmpty()) {
            return null;
        }
        for (AnnotationInstance annotationInstance : annotations) {
            if (!annotationInstance.name().equals((Object)name)) continue;
            return annotationInstance;
        }
        return null;
    }

    public static boolean contains(Collection<AnnotationInstance> annotations, DotName name) {
        return Annotations.find(annotations, name) != null;
    }

    public static boolean containsAny(Collection<AnnotationInstance> annotations, Iterable<DotName> names) {
        if (annotations.isEmpty()) {
            return false;
        }
        for (AnnotationInstance annotationInstance : annotations) {
            for (DotName name : names) {
                if (!annotationInstance.name().equals((Object)name)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<AnnotationInstance> getParameterAnnotations(Collection<AnnotationInstance> annotations) {
        return Annotations.getAnnotations(AnnotationTarget.Kind.METHOD_PARAMETER, annotations);
    }

    public static Set<AnnotationInstance> getAnnotations(AnnotationTarget.Kind kind, Collection<AnnotationInstance> annotations) {
        return Annotations.getAnnotations(kind, null, annotations);
    }

    public static Set<AnnotationInstance> getAnnotations(AnnotationTarget.Kind kind, DotName name, Collection<AnnotationInstance> annotations) {
        if (annotations.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<AnnotationInstance> ret = new HashSet<AnnotationInstance>();
        for (AnnotationInstance annotation : annotations) {
            if (kind != annotation.target().kind() || name != null && !annotation.name().equals((Object)name)) continue;
            ret.add(annotation);
        }
        return ret;
    }

    public static Set<AnnotationInstance> getParameterAnnotations(BeanDeployment beanDeployment, MethodInfo method) {
        HashSet<AnnotationInstance> annotations = new HashSet<AnnotationInstance>();
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)method)) {
            if (AnnotationTarget.Kind.METHOD_PARAMETER != annotation.target().kind()) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    public static Set<AnnotationInstance> getParameterAnnotations(BeanDeployment beanDeployment, MethodInfo method, int position) {
        return Annotations.getParameterAnnotations(beanDeployment::getAnnotations, method, position);
    }

    public static Set<AnnotationInstance> getParameterAnnotations(Function<AnnotationTarget, Collection<AnnotationInstance>> transformedAnnotations, MethodInfo method, int position) {
        HashSet<AnnotationInstance> annotations = new HashSet<AnnotationInstance>();
        for (AnnotationInstance annotation : transformedAnnotations.apply((AnnotationTarget)method)) {
            if (AnnotationTarget.Kind.METHOD_PARAMETER != annotation.target().kind() || annotation.target().asMethodParameter().position() != position) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    public static AnnotationInstance getParameterAnnotation(MethodInfo method, DotName annotation) {
        for (AnnotationInstance annotationInstance : method.annotations()) {
            if (!annotationInstance.target().kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER) || !annotationInstance.name().equals((Object)annotation)) continue;
            return annotationInstance;
        }
        return null;
    }
}

