/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.ResourceOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

class ResourceImpl
implements ResourceOutput.Resource {
    private final boolean applicationClass;
    private final String name;
    private final byte[] data;
    private final ResourceOutput.Resource.Type type;
    private final ResourceOutput.Resource.SpecialType specialType;

    static ResourceOutput.Resource javaClass(String name, byte[] data, ResourceOutput.Resource.SpecialType specialType, boolean applicationClass) {
        return new ResourceImpl(applicationClass, name, data, ResourceOutput.Resource.Type.JAVA_CLASS, specialType);
    }

    static ResourceOutput.Resource serviceProvider(String name, byte[] data) {
        return ResourceImpl.serviceProvider(name, data, null);
    }

    static ResourceOutput.Resource serviceProvider(String name, byte[] data, ResourceOutput.Resource.SpecialType specialType) {
        return new ResourceImpl(true, name, data, ResourceOutput.Resource.Type.SERVICE_PROVIDER, specialType);
    }

    private ResourceImpl(boolean applicationClass, String name, byte[] data, ResourceOutput.Resource.Type type, ResourceOutput.Resource.SpecialType specialType) {
        this.applicationClass = applicationClass;
        this.name = name;
        this.data = data;
        this.type = type;
        this.specialType = specialType;
    }

    @Override
    public boolean isApplicationClass() {
        return this.applicationClass;
    }

    @Override
    public File writeTo(File directory) throws IOException {
        switch (this.type) {
            case JAVA_CLASS: {
                Path outputPath = this.getOutputDirectory(directory).resolve(this.getSimpleName() + ".class");
                Files.write(outputPath, this.data, new OpenOption[0]);
                return outputPath.toFile();
            }
        }
        File file = new File(directory, this.name);
        file.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(this.data);
        }
        return file;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ResourceOutput.Resource.Type getType() {
        return this.type;
    }

    @Override
    public ResourceOutput.Resource.SpecialType getSpecialType() {
        return this.specialType;
    }

    private Path getOutputDirectory(File directory) throws IOException {
        Path outputDirectory = directory.toPath();
        if (this.name.contains("/")) {
            for (String packageComponent : this.name.substring(0, this.name.lastIndexOf("/")).split("/")) {
                outputDirectory = outputDirectory.resolve(packageComponent);
            }
        }
        Files.createDirectories(outputDirectory, new FileAttribute[0]);
        return outputDirectory;
    }

    private String getSimpleName() {
        return this.name.contains("/") ? this.name.substring(this.name.lastIndexOf("/") + 1, this.name.length()) : this.name;
    }
}

