/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ContextCreator;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ContextConfigurator {
    private final Consumer<ContextConfigurator> configuratorConsumer;
    Class<? extends Annotation> scopeAnnotation;
    boolean isNormal;
    Function<MethodCreator, ResultHandle> creator;
    final Map<String, Object> params;

    ContextConfigurator(Class<? extends Annotation> scopeAnnotation, Consumer<ContextConfigurator> configuratorConsumer) {
        this.scopeAnnotation = Objects.requireNonNull(scopeAnnotation);
        this.params = new HashMap<String, Object>();
        this.configuratorConsumer = configuratorConsumer;
    }

    public ContextConfigurator param(String name, Class<?> value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator param(String name, int value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator param(String name, long value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator param(String name, double value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator param(String name, String value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator param(String name, boolean value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator normal() {
        this.isNormal = true;
        return this;
    }

    public ContextConfigurator contextClass(Class<? extends InjectableContext> contextClazz) {
        return this.creator((MethodCreator mc) -> mc.newInstance(MethodDescriptor.ofConstructor((Class)contextClazz, (Class[])new Class[0]), new ResultHandle[0]));
    }

    public ContextConfigurator creator(Class<? extends ContextCreator> creatorClazz) {
        return this.creator((MethodCreator mc) -> {
            ResultHandle paramsHandle = mc.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (Map.Entry<String, Object> entry : this.params.entrySet()) {
                ResultHandle valHandle = null;
                if (entry.getValue() instanceof String) {
                    valHandle = mc.load(entry.getValue().toString());
                } else if (entry.getValue() instanceof Integer) {
                    valHandle = mc.newInstance(MethodDescriptor.ofConstructor(Integer.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{mc.load(((Integer)entry.getValue()).intValue())});
                } else if (entry.getValue() instanceof Long) {
                    valHandle = mc.newInstance(MethodDescriptor.ofConstructor(Long.class, (Class[])new Class[]{Long.TYPE}), new ResultHandle[]{mc.load(((Long)entry.getValue()).longValue())});
                } else if (entry.getValue() instanceof Double) {
                    valHandle = mc.newInstance(MethodDescriptor.ofConstructor(Double.class, (Class[])new Class[]{Double.TYPE}), new ResultHandle[]{mc.load(((Double)entry.getValue()).doubleValue())});
                } else if (entry.getValue() instanceof Class) {
                    valHandle = mc.loadClass((Class)entry.getValue());
                } else if (entry.getValue() instanceof Boolean) {
                    valHandle = mc.load(((Boolean)entry.getValue()).booleanValue());
                }
                mc.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, paramsHandle, new ResultHandle[]{mc.load(entry.getKey()), valHandle});
            }
            ResultHandle creatorHandle = mc.newInstance(MethodDescriptor.ofConstructor((Class)creatorClazz, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle ret = mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(ContextCreator.class, (String)"create", InjectableContext.class, (Class[])new Class[]{Map.class}), creatorHandle, new ResultHandle[]{paramsHandle});
            return ret;
        });
    }

    public ContextConfigurator creator(Function<MethodCreator, ResultHandle> creator) {
        this.creator = creator;
        return this;
    }

    public void done() {
        Objects.requireNonNull(this.creator);
        Objects.requireNonNull(this.configuratorConsumer).accept(this);
    }
}

