/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.Arc;
import io.quarkus.arc.Components;
import io.quarkus.arc.ComponentsProvider;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableInterceptor;
import io.quarkus.arc.InjectableReferenceProvider;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceImpl;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.objectweb.asm.Type;

public class ComponentsProviderGenerator
extends AbstractGenerator {
    static final String COMPONENTS_PROVIDER_SUFFIX = "_ComponentsProvider";
    static final String SETUP_PACKAGE = Arc.class.getPackage().getName() + ".setup";
    protected final AnnotationLiteralProcessor annotationLiterals;

    public ComponentsProviderGenerator(AnnotationLiteralProcessor annotationLiterals) {
        this.annotationLiterals = annotationLiterals;
    }

    Collection<ResourceOutput.Resource> generate(String name, BeanDeployment beanDeployment, Map<BeanInfo, String> beanToGeneratedName, Map<ObserverInfo, String> observerToGeneratedName) {
        ResourceClassOutput classOutput = new ResourceClassOutput(true);
        String generatedName = SETUP_PACKAGE + "." + name + COMPONENTS_PROVIDER_SUFFIX;
        ClassCreator componentsProvider = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{ComponentsProvider.class}).build();
        MethodCreator getComponents = (MethodCreator)componentsProvider.getMethodCreator("getComponents", Components.class, new Class[0]).setModifiers(1);
        ResultHandle beansHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
        HashMap<BeanInfo, List<BeanInfo>> beanToInjections = new HashMap<BeanInfo, List<BeanInfo>>();
        for (BeanInfo bean : beanDeployment.getBeans()) {
            if (bean.isProducerMethod() || bean.isProducerField()) {
                beanToInjections.computeIfAbsent(bean.getDeclaringBean(), d -> new ArrayList()).add(bean);
            }
            for (Injection injection : bean.getInjections()) {
                for (InjectionPointInfo injectionPointInfo : injection.injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPointInfo)) continue;
                    beanToInjections.computeIfAbsent(injectionPointInfo.getResolvedBean(), d -> new ArrayList()).add(bean);
                }
            }
            if (bean.getDisposer() != null) {
                for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPoint)) continue;
                    beanToInjections.computeIfAbsent(injectionPoint.getResolvedBean(), d -> new ArrayList()).add(bean);
                }
            }
            for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
                beanToInjections.computeIfAbsent(interceptor, d -> new ArrayList()).add(bean);
            }
        }
        for (InterceptorInfo interceptor : beanDeployment.getInterceptors()) {
            for (Injection injection : interceptor.getInjections()) {
                for (InjectionPointInfo injectionPointInfo : injection.injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPointInfo)) continue;
                    beanToInjections.computeIfAbsent(injectionPointInfo.getResolvedBean(), d -> new ArrayList()).add(interceptor);
                }
            }
        }
        HashMap<BeanInfo, ResultHandle> beanToResultHandle = new HashMap<BeanInfo, ResultHandle>();
        ArrayList<BeanInfo> processed = new ArrayList<BeanInfo>();
        boolean stuck = false;
        while (!beanToInjections.isEmpty()) {
            if (stuck) {
                throw new IllegalStateException("Circular dependencies not supported: \n" + beanToInjections.entrySet().stream().map(e -> "\t " + e.getKey() + " injected into: " + ((List)e.getValue()).stream().map(b -> b.getBeanClass().toString()).collect(Collectors.joining(", "))).collect(Collectors.joining("\n")));
            }
            stuck = true;
            Iterator<Object> iterator = beanToInjections.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                BeanInfo beanInfo = (BeanInfo)entry.getKey();
                if (this.isDependency(beanInfo, beanToInjections)) continue;
                this.addBean(getComponents, beansHandle, beanInfo, beanToGeneratedName, beanToResultHandle);
                iterator.remove();
                processed.add(beanInfo);
                stuck = false;
            }
        }
        for (BeanInfo beanInfo : beanDeployment.getBeans()) {
            if (processed.contains(beanInfo)) continue;
            this.addBean(getComponents, beansHandle, beanInfo, beanToGeneratedName, beanToResultHandle);
        }
        for (BeanInfo beanInfo : beanDeployment.getInterceptors()) {
            if (processed.contains(beanInfo)) continue;
            this.addBean(getComponents, beansHandle, beanInfo, beanToGeneratedName, beanToResultHandle);
        }
        ResultHandle observersHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (ObserverInfo observerInfo : beanDeployment.getObservers()) {
            String string = observerToGeneratedName.get(observerInfo);
            List list = observerInfo.getInjection().injectionPoints.stream().filter(ip -> !BuiltinBean.resolvesTo(ip)).collect(Collectors.toList());
            ArrayList<Object> params = new ArrayList<Object>();
            ArrayList<String> paramTypes = new ArrayList<String>();
            params.add(beanToResultHandle.get(observerInfo.getDeclaringBean()));
            paramTypes.add(Type.getDescriptor(InjectableBean.class));
            for (InjectionPointInfo injetionPoint : list) {
                ResultHandle resultHandle = (ResultHandle)beanToResultHandle.get(injetionPoint.getResolvedBean());
                params.add(resultHandle);
                paramTypes.add(Type.getDescriptor(InjectableReferenceProvider.class));
            }
            ResultHandle observerInstance = getComponents.newInstance(MethodDescriptor.ofConstructor((String)string, (String[])paramTypes.toArray(new String[0])), params.toArray(new ResultHandle[0]));
            getComponents.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, observersHandle, new ResultHandle[]{observerInstance});
        }
        ResultHandle resultHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (Map.Entry<ScopeInfo, Function<MethodCreator, ResultHandle>> entry : beanDeployment.getCustomContexts().entrySet()) {
            ResultHandle resultHandle2 = entry.getValue().apply(getComponents);
            getComponents.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, resultHandle, new ResultHandle[]{resultHandle2});
        }
        ResultHandle resultHandle3 = getComponents.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (Map.Entry<DotName, Set<AnnotationInstance>> entry : beanDeployment.getTransitiveInterceptorBindings().entrySet()) {
            ResultHandle bindingsHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (AnnotationInstance binding : entry.getValue()) {
                ClassInfo bindingClass = beanDeployment.getInterceptorBinding(binding.name());
                getComponents.invokeInterfaceMethod(MethodDescriptors.SET_ADD, bindingsHandle, new ResultHandle[]{this.annotationLiterals.process((BytecodeCreator)getComponents, classOutput, bindingClass, binding, SETUP_PACKAGE)});
            }
            getComponents.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, resultHandle3, new ResultHandle[]{getComponents.loadClass(entry.getKey().toString()), bindingsHandle});
        }
        ResultHandle resultHandle4 = getComponents.newInstance(MethodDescriptor.ofConstructor(Components.class, (Class[])new Class[]{Collection.class, Collection.class, Collection.class, Map.class}), new ResultHandle[]{beansHandle, observersHandle, resultHandle, resultHandle3});
        getComponents.returnValue(resultHandle4);
        componentsProvider.close();
        ArrayList<ResourceOutput.Resource> arrayList = new ArrayList<ResourceOutput.Resource>();
        for (ResourceOutput.Resource resource : classOutput.getResources()) {
            arrayList.add(resource);
            arrayList.add(ResourceImpl.serviceProvider(ComponentsProvider.class.getName(), resource.getName().replace('/', '.').getBytes(Charset.forName("UTF-8"))));
        }
        return arrayList;
    }

    private void addBean(MethodCreator getComponents, ResultHandle beansResultHandle, BeanInfo bean, Map<BeanInfo, String> beanToGeneratedName, Map<BeanInfo, ResultHandle> beanToResultHandle) {
        ResultHandle resultHandle;
        String beanType = beanToGeneratedName.get(bean);
        List<InjectionPointInfo> injectionPoints = bean.getInjections().isEmpty() ? Collections.emptyList() : bean.getInjections().stream().flatMap(i -> i.injectionPoints.stream()).filter(ip -> !BuiltinBean.resolvesTo(ip)).collect(Collectors.toList());
        ArrayList<ResultHandle> params = new ArrayList<ResultHandle>();
        ArrayList<String> paramTypes = new ArrayList<String>();
        if (bean.isProducerMethod() || bean.isProducerField()) {
            params.add(beanToResultHandle.get(bean.getDeclaringBean()));
            paramTypes.add(Type.getDescriptor(InjectableBean.class));
        }
        for (InjectionPointInfo injectionPoint : injectionPoints) {
            resultHandle = beanToResultHandle.get(injectionPoint.getResolvedBean());
            params.add(resultHandle);
            paramTypes.add(Type.getDescriptor(InjectableReferenceProvider.class));
        }
        if (bean.getDisposer() != null) {
            for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                resultHandle = beanToResultHandle.get(injectionPoint.getResolvedBean());
                params.add(resultHandle);
                paramTypes.add(Type.getDescriptor(InjectableReferenceProvider.class));
            }
        }
        for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
            resultHandle = beanToResultHandle.get(interceptor);
            params.add(resultHandle);
            paramTypes.add(Type.getDescriptor(InjectableInterceptor.class));
        }
        ResultHandle beanInstance = getComponents.newInstance(MethodDescriptor.ofConstructor((String)beanType, (String[])paramTypes.toArray(new String[0])), params.toArray(new ResultHandle[0]));
        getComponents.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, beansResultHandle, new ResultHandle[]{beanInstance});
        beanToResultHandle.put(bean, beanInstance);
    }

    private boolean isDependency(BeanInfo bean, Map<BeanInfo, List<BeanInfo>> beanToInjections) {
        for (Map.Entry<BeanInfo, List<BeanInfo>> entry : beanToInjections.entrySet()) {
            if (!entry.getValue().contains(bean)) continue;
            return true;
        }
        return false;
    }
}

