/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AnnotationLiteralGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanArchives;
import io.quarkus.arc.processor.BeanDefiningAnnotation;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanRegistrar;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.ClientProxyGenerator;
import io.quarkus.arc.processor.ComponentsProviderGenerator;
import io.quarkus.arc.processor.ContextRegistrar;
import io.quarkus.arc.processor.DeploymentEnhancer;
import io.quarkus.arc.processor.InjectionPointsTransformer;
import io.quarkus.arc.processor.InterceptorGenerator;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.ObserverGenerator;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.SubclassGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class BeanProcessor {
    static final String DEFAULT_NAME = "Default";
    static final Logger LOGGER = Logger.getLogger(BeanProcessor.class);
    private final String name;
    private final IndexView index;
    private final Collection<BeanDefiningAnnotation> additionalBeanDefiningAnnotations;
    private final Map<DotName, Collection<AnnotationInstance>> additionalStereotypes;
    private final ResourceOutput output;
    private final boolean sharedAnnotationLiterals;
    private final ReflectionRegistration reflectionRegistration;
    private final Collection<DotName> resourceAnnotations;
    private final List<AnnotationsTransformer> annotationTransformers;
    private final List<InjectionPointsTransformer> injectionPointsTransformers;
    private final List<BeanRegistrar> beanRegistrars;
    private final List<ContextRegistrar> contextRegistrars;
    private final List<BeanDeploymentValidator> beanDeploymentValidators;
    private final BuildContextImpl buildContext;
    private final Predicate<DotName> applicationClassPredicate;
    private final boolean removeUnusedBeans;
    private final List<Predicate<BeanInfo>> unusedExclusions;

    public static Builder builder() {
        return new Builder();
    }

    private BeanProcessor(String name, IndexView index, Collection<BeanDefiningAnnotation> additionalBeanDefiningAnnotations, ResourceOutput output, boolean sharedAnnotationLiterals, ReflectionRegistration reflectionRegistration, List<AnnotationsTransformer> annotationTransformers, List<InjectionPointsTransformer> injectionPointsTransformers, Collection<DotName> resourceAnnotations, List<BeanRegistrar> beanRegistrars, List<ContextRegistrar> contextRegistrars, List<DeploymentEnhancer> deploymentEnhancers, List<BeanDeploymentValidator> beanDeploymentValidators, Predicate<DotName> applicationClassPredicate, boolean unusedBeansRemovalEnabled, List<Predicate<BeanInfo>> unusedExclusions, Map<DotName, Collection<AnnotationInstance>> additionalStereotypes) {
        this.reflectionRegistration = reflectionRegistration;
        this.applicationClassPredicate = applicationClassPredicate;
        this.name = name;
        this.additionalBeanDefiningAnnotations = additionalBeanDefiningAnnotations;
        this.additionalStereotypes = additionalStereotypes;
        this.output = Objects.requireNonNull(output);
        this.sharedAnnotationLiterals = sharedAnnotationLiterals;
        this.resourceAnnotations = resourceAnnotations;
        this.removeUnusedBeans = unusedBeansRemovalEnabled;
        this.unusedExclusions = unusedExclusions;
        this.buildContext = new BuildContextImpl();
        this.buildContext.putInternal(BuildExtension.Key.INDEX.asString(), index);
        BeanProcessor.initAndSort(deploymentEnhancers, this.buildContext);
        if (!deploymentEnhancers.isEmpty()) {
            final Indexer indexer = new Indexer();
            DeploymentEnhancer.DeploymentContext deploymentContext = new DeploymentEnhancer.DeploymentContext(){

                @Override
                public void addClass(String className) {
                    BeanArchives.index(indexer, className);
                }

                @Override
                public void addClass(Class<?> clazz) {
                    BeanArchives.index(indexer, clazz.getName());
                }

                @Override
                public <V> V get(BuildExtension.Key<V> key) {
                    return BeanProcessor.this.buildContext.get(key);
                }

                @Override
                public <V> V put(BuildExtension.Key<V> key, V value) {
                    return BeanProcessor.this.buildContext.put(key, value);
                }
            };
            deploymentEnhancers.sort(BuildExtension::compare);
            for (DeploymentEnhancer enhancer : deploymentEnhancers) {
                enhancer.enhance(deploymentContext);
            }
            this.index = CompositeIndex.create((IndexView[])new IndexView[]{index, indexer.complete()});
        } else {
            this.index = index;
        }
        this.annotationTransformers = BeanProcessor.initAndSort(annotationTransformers, this.buildContext);
        this.injectionPointsTransformers = BeanProcessor.initAndSort(injectionPointsTransformers, this.buildContext);
        this.beanRegistrars = BeanProcessor.initAndSort(beanRegistrars, this.buildContext);
        this.contextRegistrars = BeanProcessor.initAndSort(contextRegistrars, this.buildContext);
        this.beanDeploymentValidators = BeanProcessor.initAndSort(beanDeploymentValidators, this.buildContext);
    }

    public BeanDeployment process() throws IOException {
        BeanDeployment beanDeployment = new BeanDeployment(this.index, this.additionalBeanDefiningAnnotations, this.annotationTransformers, this.injectionPointsTransformers, this.resourceAnnotations, this.beanRegistrars, this.contextRegistrars, this.buildContext, this.removeUnusedBeans, this.unusedExclusions, this.additionalStereotypes);
        beanDeployment.init();
        beanDeployment.validate(this.buildContext, this.beanDeploymentValidators);
        PrivateMembersCollector privateMembers = new PrivateMembersCollector();
        AnnotationLiteralProcessor annotationLiterals = new AnnotationLiteralProcessor(this.sharedAnnotationLiterals, this.applicationClassPredicate);
        BeanGenerator beanGenerator = new BeanGenerator(annotationLiterals, this.applicationClassPredicate, privateMembers);
        ClientProxyGenerator clientProxyGenerator = new ClientProxyGenerator(this.applicationClassPredicate);
        InterceptorGenerator interceptorGenerator = new InterceptorGenerator(annotationLiterals, this.applicationClassPredicate, privateMembers);
        SubclassGenerator subclassGenerator = new SubclassGenerator(annotationLiterals, this.applicationClassPredicate);
        ObserverGenerator observerGenerator = new ObserverGenerator(annotationLiterals, this.applicationClassPredicate, privateMembers);
        AnnotationLiteralGenerator annotationLiteralsGenerator = new AnnotationLiteralGenerator();
        HashMap<BeanInfo, String> beanToGeneratedName = new HashMap<BeanInfo, String>();
        HashMap<ObserverInfo, String> observerToGeneratedName = new HashMap<ObserverInfo, String>();
        long start = System.currentTimeMillis();
        ArrayList<ResourceOutput.Resource> resources = new ArrayList<ResourceOutput.Resource>();
        for (InterceptorInfo interceptor : beanDeployment.getInterceptors()) {
            for (ResourceOutput.Resource resource : interceptorGenerator.generate(interceptor, this.reflectionRegistration)) {
                resources.add(resource);
                if (!ResourceOutput.Resource.SpecialType.INTERCEPTOR_BEAN.equals((Object)resource.getSpecialType())) continue;
                beanToGeneratedName.put(interceptor, resource.getName());
            }
        }
        for (BeanInfo bean : beanDeployment.getBeans()) {
            for (ResourceOutput.Resource resource : beanGenerator.generate(bean, this.reflectionRegistration)) {
                resources.add(resource);
                if (!ResourceOutput.Resource.SpecialType.BEAN.equals((Object)resource.getSpecialType())) continue;
                if (bean.getScope().isNormal()) {
                    resources.addAll(clientProxyGenerator.generate(bean, resource.getFullyQualifiedName(), this.reflectionRegistration));
                }
                beanToGeneratedName.put(bean, resource.getName());
                if (!bean.isSubclassRequired()) continue;
                resources.addAll(subclassGenerator.generate(bean, resource.getFullyQualifiedName(), this.reflectionRegistration));
            }
        }
        for (ObserverInfo observer : beanDeployment.getObservers()) {
            for (ResourceOutput.Resource resource : observerGenerator.generate(observer, this.reflectionRegistration)) {
                resources.add(resource);
                if (!ResourceOutput.Resource.SpecialType.OBSERVER.equals((Object)resource.getSpecialType())) continue;
                observerToGeneratedName.put(observer, resource.getName());
            }
        }
        privateMembers.log();
        resources.addAll(new ComponentsProviderGenerator(annotationLiterals).generate(this.name, beanDeployment, beanToGeneratedName, observerToGeneratedName));
        if (annotationLiterals.hasLiteralsToGenerate()) {
            resources.addAll(annotationLiteralsGenerator.generate(this.name, beanDeployment, annotationLiterals.getCache()));
        }
        for (ResourceOutput.Resource resource : resources) {
            this.output.writeResource(resource);
        }
        LOGGER.debugf("Generated %s resources in %s ms", (long)resources.size(), System.currentTimeMillis() - start);
        return beanDeployment;
    }

    private static <E extends BuildExtension> List<E> initAndSort(List<E> extensions, BuildExtension.BuildContext buildContext) {
        Iterator<E> iterator = extensions.iterator();
        while (iterator.hasNext()) {
            if (((BuildExtension)iterator.next()).initialize(buildContext)) continue;
            iterator.remove();
        }
        extensions.sort(BuildExtension::compare);
        return extensions;
    }

    static class PrivateMembersCollector {
        private final List<String> appDescriptions = new ArrayList<String>();
        private final List<String> fwkDescriptions = LOGGER.isDebugEnabled() ? new ArrayList() : null;

        void add(boolean isApplicationClass, String description) {
            if (isApplicationClass) {
                this.appDescriptions.add(description);
            } else if (this.fwkDescriptions != null) {
                this.fwkDescriptions.add(description);
            }
        }

        private void log() {
            if (!this.appDescriptions.isEmpty()) {
                int limit = LOGGER.isDebugEnabled() ? Integer.MAX_VALUE : 3;
                String info = this.appDescriptions.stream().limit(limit).map(d -> "\t- " + d).collect(Collectors.joining(",\n"));
                if (this.appDescriptions.size() > limit) {
                    info = info + "\n\t- and " + (this.appDescriptions.size() - limit) + " more - please enable debug logging to see the full list";
                }
                LOGGER.infof("Found unrecommended usage of private members (use package-private instead) in application beans:%n%s", (Object)info);
            }
            if (this.fwkDescriptions != null && !this.fwkDescriptions.isEmpty()) {
                LOGGER.debugf("Found unrecommended usage of private members (use package-private instead) in framework beans:%n%s", (Object)this.fwkDescriptions.stream().map(d -> "\t- " + d).collect(Collectors.joining(",\n")));
            }
        }
    }

    static class BuildContextImpl
    implements BuildExtension.BuildContext {
        private final Map<String, Object> data = new ConcurrentHashMap<String, Object>();

        BuildContextImpl() {
        }

        @Override
        public <V> V get(BuildExtension.Key<V> key) {
            return (V)this.data.get(key.asString());
        }

        @Override
        public <V> V put(BuildExtension.Key<V> key, V value) {
            String keyStr = key.asString();
            if (keyStr.startsWith(BuildExtension.Key.BUILT_IN_PREFIX)) {
                throw new IllegalArgumentException("Key may not start wit " + BuildExtension.Key.BUILT_IN_PREFIX + ": " + keyStr);
            }
            return this.putInternal(keyStr, value);
        }

        <V> V putInternal(String key, V value) {
            return (V)this.data.put(key, value);
        }
    }

    public static class Builder {
        private String name = "Default";
        private IndexView index;
        private Collection<BeanDefiningAnnotation> additionalBeanDefiningAnnotations = Collections.emptySet();
        private Map<DotName, Collection<AnnotationInstance>> additionalStereotypes = Collections.emptyMap();
        private ResourceOutput output;
        private boolean sharedAnnotationLiterals = true;
        private ReflectionRegistration reflectionRegistration = ReflectionRegistration.NOOP;
        private final List<DotName> resourceAnnotations = new ArrayList<DotName>();
        private final List<AnnotationsTransformer> annotationTransformers = new ArrayList<AnnotationsTransformer>();
        private final List<InjectionPointsTransformer> injectionPointTransformers = new ArrayList<InjectionPointsTransformer>();
        private final List<BeanRegistrar> beanRegistrars = new ArrayList<BeanRegistrar>();
        private final List<ContextRegistrar> contextRegistrars = new ArrayList<ContextRegistrar>();
        private final List<DeploymentEnhancer> deploymentEnhancers = new ArrayList<DeploymentEnhancer>();
        private final List<BeanDeploymentValidator> beanDeploymentValidators = new ArrayList<BeanDeploymentValidator>();
        private boolean removeUnusedBeans = false;
        private final List<Predicate<BeanInfo>> removalExclusions = new ArrayList<Predicate<BeanInfo>>();
        private Predicate<DotName> applicationClassPredicate = new Predicate<DotName>(){

            @Override
            public boolean test(DotName dotName) {
                return true;
            }
        };

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setIndex(IndexView index) {
            this.index = index;
            return this;
        }

        public Builder setAdditionalBeanDefiningAnnotations(Collection<BeanDefiningAnnotation> additionalBeanDefiningAnnotations) {
            Objects.requireNonNull(additionalBeanDefiningAnnotations);
            this.additionalBeanDefiningAnnotations = additionalBeanDefiningAnnotations;
            return this;
        }

        public Builder setAdditionalStereotypes(Map<DotName, Collection<AnnotationInstance>> additionalStereotypes) {
            Objects.requireNonNull(additionalStereotypes);
            this.additionalStereotypes = additionalStereotypes;
            return this;
        }

        public Builder setOutput(ResourceOutput output) {
            this.output = output;
            return this;
        }

        public Builder setSharedAnnotationLiterals(boolean sharedAnnotationLiterals) {
            this.sharedAnnotationLiterals = sharedAnnotationLiterals;
            return this;
        }

        public Builder setReflectionRegistration(ReflectionRegistration reflectionRegistration) {
            this.reflectionRegistration = reflectionRegistration;
            return this;
        }

        public Builder addAnnotationTransformer(AnnotationsTransformer transformer) {
            this.annotationTransformers.add(transformer);
            return this;
        }

        public Builder addInjectionPointTransformer(InjectionPointsTransformer transformer) {
            this.injectionPointTransformers.add(transformer);
            return this;
        }

        public Builder addResourceAnnotations(Collection<DotName> resourceAnnotations) {
            this.resourceAnnotations.addAll(resourceAnnotations);
            return this;
        }

        public Builder addBeanRegistrar(BeanRegistrar registrar) {
            this.beanRegistrars.add(registrar);
            return this;
        }

        public Builder addContextRegistrar(ContextRegistrar registrar) {
            this.contextRegistrars.add(registrar);
            return this;
        }

        public Builder addDeploymentEnhancer(DeploymentEnhancer enhancer) {
            this.deploymentEnhancers.add(enhancer);
            return this;
        }

        public Builder addBeanDeploymentValidator(BeanDeploymentValidator validator) {
            this.beanDeploymentValidators.add(validator);
            return this;
        }

        public Builder setApplicationClassPredicate(Predicate<DotName> applicationClassPredicate) {
            this.applicationClassPredicate = applicationClassPredicate;
            return this;
        }

        public Builder setRemoveUnusedBeans(boolean removeUnusedBeans) {
            this.removeUnusedBeans = removeUnusedBeans;
            return this;
        }

        public Builder addRemovalExclusion(Predicate<BeanInfo> exclusion) {
            this.removalExclusions.add(exclusion);
            return this;
        }

        public BeanProcessor build() {
            return new BeanProcessor(this.name, this.index, this.additionalBeanDefiningAnnotations, this.output, this.sharedAnnotationLiterals, this.reflectionRegistration, this.annotationTransformers, this.injectionPointTransformers, this.resourceAnnotations, this.beanRegistrars, this.contextRegistrars, this.deploymentEnhancers, this.beanDeploymentValidators, this.applicationClassPredicate, this.removeUnusedBeans, this.removalExclusions, this.additionalStereotypes);
        }
    }
}

