/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.wiremock.devservice;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.common.ClasspathFileSource;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import io.quarkiverse.wiremock.devservice.WireMockServerBuildTimeConfig;
import io.quarkiverse.wiremock.devservice.WireMockServerEnabled;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.dev.devservices.DevServiceDescriptionBuildItem;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

class WireMockServerProcessor {
    private static final Logger LOGGER = Logger.getLogger(WireMockServerProcessor.class);
    private static final String FEATURE_NAME = "wiremock";
    private static final String DEV_SERVICE_NAME = "WireMock";
    private static final String MAPPINGS = "mappings";
    private static final String FILES = "__files";
    private static final int MIN_PORT = 1025;
    private static final int MAX_PORT = 65535;
    static volatile DevServicesResultBuildItem.RunningDevService devService;

    WireMockServerProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE_NAME);
    }

    @BuildStep(onlyIf={WireMockServerEnabled.class, GlobalDevServicesConfig.Enabled.class})
    DevServicesResultBuildItem setup(LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReload, CuratedApplicationShutdownBuildItem shutdown, WireMockServerBuildTimeConfig config, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> configErrors) {
        LOGGER.debugf("Quarkus launch mode [%s]", (Object)launchMode.getLaunchMode());
        if (WireMockServerProcessor.isPortConfigInvalid(config)) {
            configErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new ConfigurationException(String.format("The specified port %d is not part of the permitted port range! Please specify a port between %d and %d.", config.port().getAsInt(), 1025, 65535))}));
            return null;
        }
        shutdown.addCloseTask(WireMockServerProcessor::stopWireMockDevService, true);
        if (liveReload.isLiveReload() && config.reload()) {
            LOGGER.debug((Object)"Live reload triggered!");
            WireMockServerProcessor.stopWireMockDevService();
        }
        if (devService == null) {
            devService = WireMockServerProcessor.startWireMockDevService(config);
        }
        return devService.toBuildItem();
    }

    @BuildStep(onlyIf={WireMockServerEnabled.class, GlobalDevServicesConfig.Enabled.class})
    @Consume(value=DevServicesResultBuildItem.class)
    DevServiceDescriptionBuildItem renderDevServiceDevUICard() {
        return new DevServiceDescriptionBuildItem(DEV_SERVICE_NAME, null, devService.getConfig());
    }

    @BuildStep(onlyIf={WireMockServerEnabled.class, GlobalDevServicesConfig.Enabled.class, IsDevelopment.class})
    void watchWireMockConfigFiles(WireMockServerBuildTimeConfig config, BuildProducer<HotDeploymentWatchedFileBuildItem> items) {
        if (!config.isClasspathFilesMapping()) {
            WireMockServerProcessor.listFiles(Paths.get(config.effectiveFileMapping(), MAPPINGS), Paths.get(config.effectiveFileMapping(), FILES)).forEach(file -> {
                LOGGER.debugf("Watching [%s] for hot deployment!", file);
                items.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(file));
            });
        }
    }

    private static DevServicesResultBuildItem.RunningDevService startWireMockDevService(WireMockServerBuildTimeConfig config) {
        WireMockConfiguration configuration = WireMockConfiguration.options().globalTemplating(config.globalResponseTemplating()).extensionScanningEnabled(config.extensionScanningEnabled());
        config.port().ifPresentOrElse(arg_0 -> ((WireMockConfiguration)configuration).port(arg_0), () -> ((WireMockConfiguration)configuration).dynamicPort());
        if (config.isClasspathFilesMapping()) {
            configuration.fileSource((FileSource)new ClasspathFileSource(Thread.currentThread().getContextClassLoader(), config.effectiveFileMapping()));
        } else {
            configuration.usingFilesUnderDirectory(config.effectiveFileMapping());
        }
        WireMockServer server = new WireMockServer((Options)configuration);
        server.start();
        LOGGER.debugf("WireMock server listening on port [%s]", server.port());
        return new DevServicesResultBuildItem.RunningDevService(DEV_SERVICE_NAME, null, () -> ((WireMockServer)server).shutdown(), "quarkus.wiremock.devservices.port", String.valueOf(server.port()));
    }

    private static synchronized void stopWireMockDevService() {
        try {
            if (devService != null) {
                LOGGER.debugf("Stopping WireMock server running on port %s", devService.getConfig().get("quarkus.wiremock.devservices.port"));
                devService.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Failed to stop WireMock server", (Throwable)e);
            throw new UncheckedIOException(e);
        }
        finally {
            devService = null;
        }
    }

    private static boolean isPortConfigInvalid(WireMockServerBuildTimeConfig config) {
        if (config.port().isEmpty()) {
            return false;
        }
        int port = config.port().getAsInt();
        return port < 1025 || port > 65535;
    }

    private static Set<String> listFiles(Path ... dirs) {
        return Arrays.stream(dirs).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(WireMockServerProcessor::fileWalk).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Set<String> fileWalk(Path start) {
        Set<String> set;
        block8: {
            Stream<Path> stream = Files.walk(start, new FileVisitOption[0]);
            try {
                set = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.toSet());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return set;
    }
}

