/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingjson.jackson;

import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.quarkiverse.loggingjson.JsonFactory;
import io.quarkiverse.loggingjson.JsonGenerator;
import io.quarkiverse.loggingjson.StringBuilderWriter;
import io.quarkiverse.loggingjson.config.Config;
import io.quarkiverse.loggingjson.jackson.JacksonJsonGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.ServiceConfigurationError;

public class JacksonJsonFactory
implements JsonFactory {
    private com.fasterxml.jackson.core.JsonFactory jsonFactory = this.createJsonFactory(false);

    private com.fasterxml.jackson.core.JsonFactory createJsonFactory(boolean prettyPrint) {
        ObjectMapper objectMapper = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        try {
            objectMapper.findAndRegisterModules();
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            System.err.println("Error occurred while dynamically loading jackson modules");
            serviceConfigurationError.printStackTrace();
        }
        JsonFactoryBuilder builder = new JsonFactoryBuilder(objectMapper.getFactory());
        if (prettyPrint) {
            builder.addDecorator((factory, generator) -> generator.useDefaultPrettyPrinter());
        }
        return builder.build().setCodec((ObjectCodec)objectMapper).disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
    }

    @Override
    public void setConfig(Config config) {
        this.jsonFactory = this.createJsonFactory(config.prettyPrint());
    }

    @Override
    public JsonGenerator createGenerator(StringBuilderWriter writer) throws IOException {
        return new JacksonJsonGenerator(this.jsonFactory.createGenerator((Writer)writer));
    }
}

