/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingjson.providers;

import io.quarkiverse.loggingjson.Enabled;
import io.quarkiverse.loggingjson.JsonGenerator;
import io.quarkiverse.loggingjson.JsonProvider;
import io.quarkiverse.loggingjson.JsonWritingUtils;
import io.quarkiverse.loggingjson.config.Config;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.jboss.logmanager.ExtLogRecord;

public class TimestampJsonProvider
implements JsonProvider,
Enabled {
    private final String fieldName;
    private final DateTimeFormatter dateTimeFormatter;
    private final Config.TimestampField config;

    public TimestampJsonProvider(Config.TimestampField config) {
        this(config, "timestamp");
    }

    public TimestampJsonProvider(Config.TimestampField config, String defaultName) {
        this.config = config;
        this.fieldName = config.fieldName.orElse(defaultName);
        ZoneId zoneId = config.zoneId == null || "default".equals(config.zoneId) ? ZoneId.systemDefault() : ZoneId.of(config.zoneId);
        this.dateTimeFormatter = config.dateFormat != null && !config.dateFormat.equals("default") ? DateTimeFormatter.ofPattern(config.dateFormat).withZone(zoneId) : DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(zoneId);
    }

    @Override
    public void writeTo(JsonGenerator generator, ExtLogRecord event) throws IOException {
        long millis = event.getMillis();
        JsonWritingUtils.writeStringField(generator, this.fieldName, this.dateTimeFormatter.format(Instant.ofEpochMilli(millis)));
    }

    @Override
    public boolean isEnabled() {
        return this.config.enabled.orElse(true);
    }
}

