/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingjson;

import io.quarkiverse.loggingjson.Enabled;
import io.quarkiverse.loggingjson.JsonFactory;
import io.quarkiverse.loggingjson.JsonFormatter;
import io.quarkiverse.loggingjson.JsonProvider;
import io.quarkiverse.loggingjson.config.Config;
import io.quarkiverse.loggingjson.config.ConfigFormatter;
import io.quarkiverse.loggingjson.jackson.JacksonJsonFactory;
import io.quarkiverse.loggingjson.jsonb.JsonbJsonFactory;
import io.quarkiverse.loggingjson.providers.AdditionalFieldsJsonProvider;
import io.quarkiverse.loggingjson.providers.ArgumentsJsonProvider;
import io.quarkiverse.loggingjson.providers.ErrorMessageJsonProvider;
import io.quarkiverse.loggingjson.providers.ErrorTypeJsonProvider;
import io.quarkiverse.loggingjson.providers.HostNameJsonProvider;
import io.quarkiverse.loggingjson.providers.LogLevelJsonProvider;
import io.quarkiverse.loggingjson.providers.LoggerClassNameJsonProvider;
import io.quarkiverse.loggingjson.providers.LoggerNameJsonProvider;
import io.quarkiverse.loggingjson.providers.MDCJsonProvider;
import io.quarkiverse.loggingjson.providers.MessageJsonProvider;
import io.quarkiverse.loggingjson.providers.NDCJsonProvider;
import io.quarkiverse.loggingjson.providers.ProcessIdJsonProvider;
import io.quarkiverse.loggingjson.providers.ProcessNameJsonProvider;
import io.quarkiverse.loggingjson.providers.SequenceJsonProvider;
import io.quarkiverse.loggingjson.providers.StackTraceJsonProvider;
import io.quarkiverse.loggingjson.providers.StaticKeyValueProvider;
import io.quarkiverse.loggingjson.providers.ThreadIdJsonProvider;
import io.quarkiverse.loggingjson.providers.ThreadNameJsonProvider;
import io.quarkiverse.loggingjson.providers.TimestampJsonProvider;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Formatter;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Recorder
public class LoggingJsonRecorder {
    private static final Logger log = LoggerFactory.getLogger(LoggingJsonRecorder.class);

    public RuntimeValue<Optional<Formatter>> initializeConsoleJsonLogging(Config config, boolean useJackson) {
        return this.initializeJsonLogging(config.console, config, useJackson);
    }

    public RuntimeValue<Optional<Formatter>> initializeFileJsonLogging(Config config, boolean useJackson) {
        return this.initializeJsonLogging(config.file, config, useJackson);
    }

    public RuntimeValue<Optional<Formatter>> initializeJsonLogging(ConfigFormatter formatter, Config config, boolean useJackson) {
        JsonFactory jsonFactory;
        if (formatter == null || !formatter.isEnabled()) {
            return new RuntimeValue(Optional.empty());
        }
        List<JsonProvider> providers = config.logFormat == Config.LogFormat.ECS ? this.ecsFormat(config) : this.defaultFormat(config);
        InjectableInstance instance = Arc.container().select(JsonProvider.class, new Annotation[0]);
        instance.forEach(providers::add);
        providers.removeIf(p -> {
            if (p instanceof Enabled) {
                return !((Enabled)((Object)p)).isEnabled();
            }
            return false;
        });
        if (log.isDebugEnabled()) {
            String installedProviders = providers.stream().map(p -> p.getClass().toString()).collect(Collectors.joining(", ", "[", "]"));
            log.debug("Installed json providers {}", (Object)installedProviders);
        }
        if (useJackson) {
            log.debug("Using Jackson as the json implementation");
            jsonFactory = new JacksonJsonFactory();
        } else {
            log.debug("Using Jsonb as the json implementation");
            jsonFactory = new JsonbJsonFactory();
        }
        return new RuntimeValue(Optional.of(new JsonFormatter(providers, jsonFactory, config)));
    }

    private List<JsonProvider> defaultFormat(Config config) {
        ArrayList<JsonProvider> providers = new ArrayList<JsonProvider>();
        providers.add(new TimestampJsonProvider(config.fields.timestamp));
        providers.add(new SequenceJsonProvider(config.fields.sequence));
        providers.add(new LoggerClassNameJsonProvider(config.fields.loggerClassName));
        providers.add(new LoggerNameJsonProvider(config.fields.loggerName));
        providers.add(new LogLevelJsonProvider(config.fields.level));
        providers.add(new MessageJsonProvider(config.fields.message));
        providers.add(new ThreadNameJsonProvider(config.fields.threadName));
        providers.add(new ThreadIdJsonProvider(config.fields.threadId));
        providers.add(new MDCJsonProvider(config.fields.mdc));
        providers.add(new NDCJsonProvider(config.fields.ndc));
        providers.add(new HostNameJsonProvider(config.fields.hostname));
        providers.add(new ProcessNameJsonProvider(config.fields.processName));
        providers.add(new ProcessIdJsonProvider(config.fields.processId));
        providers.add(new StackTraceJsonProvider(config.fields.stackTrace));
        providers.add(new ErrorTypeJsonProvider(config.fields.errorType));
        providers.add(new ErrorMessageJsonProvider(config.fields.errorMessage));
        providers.add(new ArgumentsJsonProvider(config.fields.arguments));
        providers.add(new AdditionalFieldsJsonProvider(config.additionalField));
        return providers;
    }

    private List<JsonProvider> ecsFormat(Config config) {
        ArrayList<JsonProvider> providers = new ArrayList<JsonProvider>();
        providers.add(new TimestampJsonProvider(config.fields.timestamp, "@timestamp"));
        providers.add(new LoggerNameJsonProvider(config.fields.loggerName, "log.logger"));
        providers.add(new LogLevelJsonProvider(config.fields.level, "log.level"));
        providers.add(new ThreadNameJsonProvider(config.fields.threadName, "process.thread.name"));
        providers.add(new ThreadIdJsonProvider(config.fields.threadId, "process.thread.id"));
        providers.add(new MDCJsonProvider(config.fields.mdc));
        providers.add(new HostNameJsonProvider(config.fields.hostname, "host.name"));
        providers.add(new StackTraceJsonProvider(config.fields.stackTrace, "error.stack_trace"));
        providers.add(new ErrorTypeJsonProvider(config.fields.errorType, "error.type"));
        providers.add(new ErrorMessageJsonProvider(config.fields.errorMessage, "error.message"));
        providers.add(new ArgumentsJsonProvider(config.fields.arguments));
        providers.add(new AdditionalFieldsJsonProvider(config.additionalField));
        providers.add(new MessageJsonProvider(config.fields.message));
        providers.add(new StaticKeyValueProvider("ecs.version", "1.12.1"));
        return providers;
    }
}

