/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingjson.deployment;

import io.quarkiverse.loggingjson.JsonFactory;
import io.quarkiverse.loggingjson.LoggingJsonRecorder;
import io.quarkiverse.loggingjson.deployment.LoggingJsonDotNames;
import io.quarkiverse.loggingjson.jackson.JacksonJsonFactory;
import io.quarkiverse.loggingjson.jsonb.JsonbJsonFactory;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LogConsoleFormatBuildItem;
import io.quarkus.deployment.builditem.LogFileFormatBuildItem;
import io.quarkus.deployment.builditem.LogSocketFormatBuildItem;
import java.util.Collection;
import org.jboss.jandex.ClassInfo;

class LoggingJsonProcessor {
    private static final String FEATURE = "logging-json";

    LoggingJsonProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    LogConsoleFormatBuildItem setUpConsoleFormatter(Capabilities capabilities, LoggingJsonRecorder recorder) {
        return new LogConsoleFormatBuildItem(recorder.initializeConsoleJsonLogging(this.jsonFactory(capabilities)));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    LogFileFormatBuildItem setUpFileFormatter(Capabilities capabilities, LoggingJsonRecorder recorder) {
        return new LogFileFormatBuildItem(recorder.initializeFileJsonLogging(this.jsonFactory(capabilities)));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    LogSocketFormatBuildItem setUpSocketFormatter(Capabilities capabilities, LoggingJsonRecorder recorder) {
        return new LogSocketFormatBuildItem(recorder.initializeSocketJsonLogging(this.jsonFactory(capabilities)));
    }

    private JsonFactory jsonFactory(Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.jackson")) {
            return new JacksonJsonFactory();
        }
        if (capabilities.isPresent("io.quarkus.jsonb")) {
            return new JsonbJsonFactory();
        }
        throw new RuntimeException("Missing json implementation to use for logging-json. Supported: [quarkus-jackson, quarkus-jsonb]");
    }

    @BuildStep
    void discoverJsonProviders(BuildProducer<AdditionalBeanBuildItem> beans, CombinedIndexBuildItem combinedIndexBuildItem) {
        Collection jsonProviders = combinedIndexBuildItem.getIndex().getAllKnownImplementations(LoggingJsonDotNames.JSON_PROVIDER);
        for (ClassInfo provider : jsonProviders) {
            beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)provider.name().toString()));
        }
    }
}

