/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.wsdl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.XMLStreamReaderWrapper;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.TransportURIResolver;
import org.apache.cxf.wsdl11.CatalogWSDLLocator;
import org.apache.cxf.wsdl11.ResourceManagerWSDLLocator;
import org.apache.cxf.wsdl11.WSDLManagerImpl;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class QuarkusWSDLManager
extends WSDLManagerImpl {
    private final ExtensionRegistry registry = (ExtensionRegistry)QuarkusWSDLManager.getField(WSDLManagerImpl.class, (Object)this, "registry");
    private XMLStreamReaderWrapper xmlStreamReaderWrapper;

    public static QuarkusWSDLManager newInstance(Bus b) {
        try {
            return new QuarkusWSDLManager(b);
        }
        catch (BusException e) {
            throw new RuntimeException(e);
        }
    }

    private QuarkusWSDLManager(Bus b) throws BusException {
        this.setBus(b);
    }

    private static <T> T getField(Class<?> cl, Object inst, String fieldName) {
        try {
            Field fld = cl.getDeclaredField(fieldName);
            fld.setAccessible(true);
            return (T)fld.get(inst);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setField(Class<?> cl, Object inst, String fieldName, Object value) {
        try {
            Field fld = cl.getDeclaredField(fieldName);
            fld.setAccessible(true);
            fld.set(inst, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    protected Definition loadDefinition(String url) throws WSDLException {
        Definition def;
        Bus bus = this.getBus();
        WSDLReader reader = this.getWSDLFactory().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        reader.setExtensionRegistry(this.registry);
        url = new String(url);
        CatalogWSDLLocator catLocator = new CatalogWSDLLocator(url, bus);
        QuarkusWSDLManager.setField(CatalogWSDLLocator.class, catLocator, "resolver", (Object)new QuarkusTransportURIResolver(bus));
        ResourceManagerWSDLLocator wsdlLocator = new ResourceManagerWSDLLocator(url, (WSDLLocator)catLocator, bus);
        InputSource src = wsdlLocator.getBaseInputSource();
        if (src.getByteStream() != null || src.getCharacterStream() != null) {
            Document doc;
            XMLStreamReader xmlReader = null;
            try {
                xmlReader = StaxUtils.createXMLStreamReader((InputSource)src);
                if (this.xmlStreamReaderWrapper != null) {
                    xmlReader = this.xmlStreamReaderWrapper.wrap(xmlReader);
                }
                doc = StaxUtils.read((XMLStreamReader)xmlReader, (boolean)true);
                if (src.getSystemId() != null) {
                    try {
                        doc.setDocumentURI(new String(src.getSystemId()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                throw new WSDLException("PARSER_ERROR", e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    StaxUtils.close((XMLStreamReader)xmlReader);
                }
                catch (XMLStreamException ex) {
                    throw new WSDLException("PARSER_ERROR", ex.getMessage(), (Throwable)ex);
                }
            }
            if (System.getSecurityManager() == null) {
                def = reader.readWSDL((WSDLLocator)wsdlLocator, doc.getDocumentElement());
            } else {
                try {
                    def = AccessController.doPrivileged(() -> reader.readWSDL((WSDLLocator)wsdlLocator, doc.getDocumentElement()));
                }
                catch (PrivilegedActionException paex) {
                    throw new WSDLException("PARSER_ERROR", paex.getMessage(), (Throwable)paex);
                }
            }
        } else if (System.getSecurityManager() == null) {
            def = reader.readWSDL((WSDLLocator)wsdlLocator);
        } else {
            try {
                def = AccessController.doPrivileged(() -> reader.readWSDL((WSDLLocator)wsdlLocator));
            }
            catch (PrivilegedActionException paex) {
                throw new WSDLException("PARSER_ERROR", paex.getMessage(), (Throwable)paex);
            }
        }
        return def;
    }

    public void setXMLStreamReaderWrapper(XMLStreamReaderWrapper wrapper) {
        super.setXMLStreamReaderWrapper(wrapper);
        this.xmlStreamReaderWrapper = wrapper;
    }

    static class QuarkusTransportURIResolver
    extends TransportURIResolver {
        static final Logger LOG = LogUtils.getL7dLogger(TransportURIResolver.class);
        private static final Set<String> DEFAULT_URI_RESOLVER_HANDLES = new HashSet<String>();

        public QuarkusTransportURIResolver(Bus b) {
            super(b);
        }

        public InputSource resolve(String curUri, String baseUri) {
            URI base;
            curUri = curUri.replace(" ", "%20");
            InputSource is = null;
            try {
                if (baseUri == null) {
                    base = new URI(curUri);
                } else {
                    base = new URI(baseUri);
                    base = base.resolve(curUri);
                }
            }
            catch (URISyntaxException use) {
                base = null;
                LOG.log(Level.FINEST, "Could not resolve curUri " + curUri, use);
            }
            try {
                if (base == null || DEFAULT_URI_RESOLVER_HANDLES.contains(base.getScheme())) {
                    is = super.resolve(curUri, baseUri);
                }
            }
            catch (Exception ex) {
                LOG.log(Level.FINEST, "Default URI handlers could not resolve " + baseUri + " " + curUri, ex);
            }
            if (is == null && base != null && base.getScheme() != null && !DEFAULT_URI_RESOLVER_HANDLES.contains(base.getScheme())) {
                try {
                    ConduitInitiatorManager mgr = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
                    ConduitInitiator ci = null;
                    if ("http".equals(base.getScheme()) || "https".equals(base.getScheme())) {
                        ci = mgr.getConduitInitiator("http://cxf.apache.org/transports/http");
                    }
                    if (ci == null) {
                        ci = mgr.getConduitInitiatorForUri(base.toString());
                    }
                    if (ci != null) {
                        EndpointInfo info = new EndpointInfo();
                        info.setName(new QName("http://cxf.apache.org", "TransportURIResolver"));
                        info.setAddress(base.toString());
                        Conduit c = ci.getConduit(info, this.bus);
                        MessageImpl message = new MessageImpl();
                        ExchangeImpl exch = new ExchangeImpl();
                        exch.put(Bus.class, (Object)this.bus);
                        message.setExchange((Exchange)exch);
                        message.put((Object)"org.apache.cxf.request.method", (Object)"GET");
                        c.setMessageObserver(new MessageObserver(){

                            public void onMessage(Message message) {
                                LoadingByteArrayOutputStream bout = new LoadingByteArrayOutputStream();
                                try {
                                    IOUtils.copyAndCloseInput((InputStream)((InputStream)message.getContent(InputStream.class)), (OutputStream)bout);
                                    message.getExchange().put(InputStream.class, (Object)bout.createInputStream());
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        });
                        c.prepare((Message)message);
                        c.close((Message)message);
                        if (exch.getInMessage() != null) {
                            c.close(exch.getInMessage());
                        }
                        if (exch.getInFaultMessage() != null) {
                            c.close(exch.getInFaultMessage());
                        }
                        c.close();
                        InputStream ins = (InputStream)exch.get(InputStream.class);
                        this.resourceOpened.add(ins);
                        InputSource src = new InputSource(ins);
                        String u = (String)message.get((Object)"transport.retransmit.url");
                        if (u == null) {
                            u = base.toString();
                        }
                        src.setPublicId(u);
                        src.setSystemId(u);
                        this.lastestImportUri = u;
                        this.currentResolver.unresolve();
                        return src;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Conduit initiator could not resolve " + baseUri + " " + curUri, e);
                }
            }
            if (!(is != null || base != null && base.getScheme() != null && DEFAULT_URI_RESOLVER_HANDLES.contains(base.getScheme()))) {
                is = super.resolve(curUri, baseUri);
            }
            return is;
        }

        static {
            DEFAULT_URI_RESOLVER_HANDLES.add("file");
            DEFAULT_URI_RESOLVER_HANDLES.add("classpath");
            DEFAULT_URI_RESOLVER_HANDLES.add("wsjar");
            DEFAULT_URI_RESOLVER_HANDLES.add("jar");
            DEFAULT_URI_RESOLVER_HANDLES.add("zip");
        }
    }
}

