/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.CXFRuntimeUtils;
import io.quarkiverse.cxf.CxfClientConfig;
import io.quarkiverse.cxf.vertx.http.client.HttpClientPool;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.runtime.VertxCertificateHolder;
import io.quarkus.tls.runtime.config.TlsBucketConfig;
import io.vertx.core.Vertx;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.KeyStoreOptionsBase;
import java.io.IOException;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public interface HTTPConduitSpec {
    default public HTTPConduitSpec resolveDefault() {
        return this;
    }

    public HTTPConduit createConduit(CXFClientInfo var1, HttpClientPool var2, Bus var3, EndpointInfo var4, EndpointReferenceType var5) throws IOException;

    default public Optional<TLSClientParameters> tlsClientParameters(CXFClientInfo cxfClientInfo, Vertx vertx) {
        String hostnameVerifierName = cxfClientInfo.getHostnameVerifier();
        TlsConfiguration tlsConfig = cxfClientInfo.getTlsConfiguration();
        if (hostnameVerifierName != null || tlsConfig != null) {
            TLSClientParameters tlsCP = this.createTLSClientParameters(cxfClientInfo);
            if (hostnameVerifierName != null) {
                Optional<CxfClientConfig.WellKnownHostnameVerifier> wellKnownHostNameVerifierName = CxfClientConfig.WellKnownHostnameVerifier.of(hostnameVerifierName);
                if (wellKnownHostNameVerifierName.isPresent()) {
                    wellKnownHostNameVerifierName.get().configure(tlsCP);
                } else {
                    HostnameVerifier hostnameVerifier = (HostnameVerifier)CXFRuntimeUtils.getInstance(hostnameVerifierName, true);
                    if (hostnameVerifier == null) {
                        throw new RuntimeException("Could not find or instantiate " + hostnameVerifierName);
                    }
                    tlsCP.setHostnameVerifier(hostnameVerifier);
                }
            }
            if (tlsConfig != null) {
                KeyCertOptions keyStoreOptions = tlsConfig.getKeyStoreOptions();
                if (keyStoreOptions != null) {
                    KeyStoreOptionsBase keyStoreOptionsBase;
                    try {
                        KeyManagerFactory kmf = keyStoreOptions.getKeyManagerFactory(vertx);
                        tlsCP.setKeyManagers(kmf.getKeyManagers());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not set up key manager factory", e);
                    }
                    if (keyStoreOptions instanceof KeyStoreOptionsBase && (keyStoreOptionsBase = (KeyStoreOptionsBase)keyStoreOptions).getAlias() != null) {
                        tlsCP.setCertAlias(keyStoreOptionsBase.getAlias());
                    }
                }
                if (tlsConfig.getTrustStoreOptions() != null) {
                    try {
                        TrustManagerFactory tmf = tlsConfig.getTrustStoreOptions().getTrustManagerFactory(vertx);
                        tlsCP.setTrustManagers(tmf.getTrustManagers());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not set up trust manager factory", e);
                    }
                }
            }
            return Optional.of(tlsCP);
        }
        return Optional.empty();
    }

    default public TLSClientParameters createTLSClientParameters(CXFClientInfo cxfClientInfo) {
        TlsConfiguration tlsConfig = cxfClientInfo.getTlsConfiguration();
        TLSClientParameters tlsCP = new TLSClientParameters();
        if (tlsConfig instanceof VertxCertificateHolder) {
            VertxCertificateHolder vertxCertificateHOlder = (VertxCertificateHolder)tlsConfig;
            TlsBucketConfig bucketConfig = vertxCertificateHOlder.config();
            bucketConfig.cipherSuites().ifPresent(arg_0 -> ((TLSClientParameters)tlsCP).setCipherSuites(arg_0));
            if (tlsConfig.isTrustAll()) {
                throw new IllegalStateException(this.getClass().getName().replace("Factory", "") + " does not support quarkus.tls." + cxfClientInfo.getConfigKey() + ".trust-all. ");
            }
            if (tlsConfig.getHostnameVerificationAlgorithm().isPresent()) {
                throw new IllegalStateException(this.getConduitDescription() + " does not support quarkus.tls." + cxfClientInfo.getConfigKey() + ".hostname-verification-algorithm. Use quarkus.cxf.client." + cxfClientInfo.getConfigKey() + ".hostname-verifier instead.");
            }
            if (bucketConfig.reloadPeriod().isPresent()) {
                throw new IllegalStateException(this.getConduitDescription() + " does not support quarkus.tls." + cxfClientInfo.getConfigKey() + ".reload-period. Remove the setting and restart the application with the new trust or key stores.");
            }
        }
        return tlsCP;
    }

    public String getConduitDescription();
}

