/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.QuarkusHTTPConduitFactory;
import io.quarkus.arc.Arc;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.CDI;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public class CXFRuntimeUtils {
    public static <T> T getInstance(String beanRef, boolean namedBeansSupported) {
        if (namedBeansSupported && beanRef != null && beanRef.startsWith("#")) {
            String beanName = beanRef.substring(1);
            return (T)Arc.container().instance(beanName).get();
        }
        Class<?> classObj = CXFRuntimeUtils.loadClass(beanRef);
        Objects.requireNonNull(classObj, "Could not load class " + beanRef);
        return (T)CXFRuntimeUtils.getInstance(classObj);
    }

    public static <T> T getInstance(Class<? extends T> beanClass) {
        try {
            return (T)CDI.current().select(beanClass, new Annotation[0]).get();
        }
        catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {
            try {
                return beanClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Could not instantiate " + beanClass.getName() + " using the default constructor. Make sure that the constructor exists and that the class is static in case it is an inner class.", e);
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                throw new RuntimeException("Could not instantiate " + beanClass.getName() + " using the default constructor.", e);
            }
        }
    }

    public static <T> T getInstance(String beanRef, String beanKind, String sei, String clientOrEndpoint) {
        try {
            return CXFRuntimeUtils.getInstance(beanRef, true);
        }
        catch (AmbiguousResolutionException e) {
            throw new IllegalStateException("Unable to add a " + beanKind + " to CXF " + clientOrEndpoint + " " + sei + ": there are multiple instances of " + beanRef + " available in the CDI container. Either make sure there is only one instance available in the container or create a unique subtype of " + beanRef + " and set that one on " + sei + " or add @jakarta.inject.Named(\"myName\") to some of the beans and refer to that bean by #myName on " + sei, e);
        }
    }

    public static <T> T getInstance(Class<? extends T> beanClass, String beanKind, String sei, String clientOrEndpoint) {
        try {
            return CXFRuntimeUtils.getInstance(beanClass);
        }
        catch (AmbiguousResolutionException e) {
            throw new IllegalStateException("Unable to add a " + beanKind + " to CXF " + clientOrEndpoint + " " + sei + ": there are multiple instances of " + beanClass.getName() + " available in the CDI container. Either make sure there is only one instance available in the container or create a unique subtype of " + beanClass.getName() + " and set that one on " + sei + " or add @jakarta.inject.Named(\"myName\") to some of the beans and refer to that bean by #myName on " + sei, e);
        }
    }

    public static <T> void addBeans(List<String> beanRefs, String beanKind, String sei, String clientOrEndpoint, List<T> destination) {
        for (String beanRef : beanRefs) {
            T item = CXFRuntimeUtils.getInstance(beanRef, beanKind, sei, clientOrEndpoint);
            if (item == null) {
                throw new IllegalStateException("Could not lookup bean " + beanRef);
            }
            destination.add(item);
        }
    }

    public static <T> void addBeansByType(List<Class<? extends T>> beanTypes, String beanKind, String sei, String clientOrEndpoint, List<T> destination) {
        for (Class<T> beanType : beanTypes) {
            T item = CXFRuntimeUtils.getInstance(beanType, beanKind, sei, clientOrEndpoint);
            if (item == null) {
                throw new IllegalStateException("Could not lookup bean " + beanType.getName());
            }
            destination.add(item);
        }
    }

    private static Class<?> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e1) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e2) {
                e1.addSuppressed(e2);
                throw new RuntimeException("Could not load " + className + " using current thread class loader nor " + CXFRuntimeUtils.class.getName() + " class loader", e1);
            }
        }
    }

    public static InputStream openStream(String keystorePath) throws IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(keystorePath);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not open " + keystorePath + " from the class path", e);
            }
        }
        Path path = Path.of(keystorePath, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not open " + keystorePath + " from the filesystem", e);
            }
        }
        String msg = "Resource " + keystorePath + " exists neither in class path nor in the filesystem";
        QuarkusHTTPConduitFactory.log.error((Object)msg);
        throw new IllegalStateException(msg);
    }

    public static byte[] read(String keystorePath) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(keystorePath);
        if (url != null) {
            byte[] byArray;
            block12: {
                InputStream in = url.openStream();
                try {
                    byArray = in.readAllBytes();
                    if (in == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not open " + keystorePath + " from the class path", e);
                    }
                }
                in.close();
            }
            return byArray;
        }
        Path path = Path.of(keystorePath, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return Files.readAllBytes(path);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not open " + keystorePath + " from the filesystem", e);
            }
        }
        String msg = "Resource " + keystorePath + " exists neither in class path nor in the filesystem";
        QuarkusHTTPConduitFactory.log.error((Object)msg);
        throw new IllegalStateException(msg);
    }
}

