/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.saaj.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import java.util.stream.Stream;

class SaajImplProcessor {
    SaajImplProcessor() {
    }

    @BuildStep
    void indexDependencies(BuildProducer<IndexDependencyBuildItem> indexDependencies) {
        Stream.of("com.sun.xml.messaging.saaj:saaj-impl").forEach(ga -> {
            String[] coords = ga.split(":");
            indexDependencies.produce((BuildItem)new IndexDependencyBuildItem(coords[0], coords[1]));
        });
    }

    @BuildStep
    void serviceProviders(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        String[] soapVersions;
        for (String version : soapVersions = new String[]{"1_1", "1_2"}) {
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("jakarta.xml.soap.MessageFactory", new String[]{"com.sun.xml.messaging.saaj.soap.ver" + version + ".SOAPMessageFactory" + version + "Impl"}));
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("jakarta.xml.soap.SOAPFactory", new String[]{"com.sun.xml.messaging.saaj.soap.ver" + version + ".SOAPFactory" + version + "Impl"}));
        }
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("jakarta.xml.soap.SOAPConnectionFactory", new String[]{"com.sun.xml.messaging.saaj.client.p2p.HttpSOAPConnectionFactory"}));
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("jakarta.xml.soap.SAAJMetaFactory", new String[]{"com.sun.xml.messaging.saaj.soap.SAAJMetaFactoryImpl"}));
    }

    @BuildStep
    void runtimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClasses) {
        Stream.of("com.sun.xml.messaging.saaj.soap.GifDataContentHandler", "com.sun.xml.messaging.saaj.soap.MultipartDataContentHandler", "com.sun.xml.messaging.saaj.soap.StringDataContentHandler").map(RuntimeInitializedClassBuildItem::new).forEach(arg_0 -> runtimeInitializedClasses.produce(arg_0));
    }
}

