/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.bucket4j.runtime;

import io.quarkiverse.bucket4j.runtime.BucketPodStorage;
import io.quarkiverse.bucket4j.runtime.RateLimitException;
import io.quarkiverse.bucket4j.runtime.RateLimited;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@RateLimited
@Interceptor
@Priority(value=1000)
public class RateLimitedInterceptor {
    @Inject
    BucketPodStorage bucketPodStorage;
    @ConfigProperty(name="quarkus.rate-limiter.enabled")
    boolean enabled;

    @AroundInvoke
    Object around(InvocationContext context) throws Throwable {
        if (!this.enabled) {
            return context.proceed();
        }
        long nanoWaitTime = this.bucketPodStorage.getBucketPod(context.getMethod()).consumeAndReturnNanoWaitTime();
        if (nanoWaitTime == 0L) {
            return context.proceed();
        }
        throw new RateLimitException(nanoWaitTime / 1000000L);
    }
}

