/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.bucket4j.deployment.devui;

import io.github.bucket4j.BucketConfiguration;
import io.quarkiverse.bucket4j.deployment.RateLimitCheckBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.ExternalPageBuilder;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.TableDataPageBuilder;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Bucket4jDevUIProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    void createVersion(BuildProducer<CardPageBuildItem> cardPageBuildItemBuildProducer, List<RateLimitCheckBuildItem> rateLimitChecks) {
        CardPageBuildItem card = new CardPageBuildItem();
        PageBuilder versionPage = (PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"Version").icon("font-awesome-solid:bucket")).url("https://bucket4j.com/").doNotEmbed().staticLabel(Objects.toString(BucketConfiguration.class.getPackage().getImplementationVersion(), "8.2.0"));
        card.addPage(versionPage);
        PageBuilder bucketsPage = (PageBuilder)((TableDataPageBuilder)((TableDataPageBuilder)Page.tableDataPageBuilder((String)"Buckets").icon("font-awesome-solid:bucket")).staticLabel(String.valueOf(rateLimitChecks.stream().map(RateLimitCheckBuildItem::getBucket).distinct().count()))).showColumn("bucket").showColumn("method").buildTimeDataKey("rateLimitChecks");
        card.addPage(bucketsPage);
        card.addBuildTimeData("rateLimitChecks", rateLimitChecks.stream().map(RateLimitCheckBuildTimeData::new).collect(Collectors.toList()));
        card.setCustomCard("qwc-bucket4j-card.js");
        cardPageBuildItemBuildProducer.produce((BuildItem)card);
    }

    static class RateLimitCheckBuildTimeData {
        private final String bucket;
        private final String method;

        RateLimitCheckBuildTimeData(RateLimitCheckBuildItem item) {
            this.bucket = item.getBucket();
            this.method = item.getMethodDescription().toString();
        }

        public String getMethod() {
            return this.method;
        }

        public String getBucket() {
            return this.bucket;
        }
    }
}

