/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.bucket4j.deployment;

import io.quarkiverse.bucket4j.deployment.RateLimitCheckBuildItem;
import io.quarkiverse.bucket4j.runtime.BucketPodStorage;
import io.quarkiverse.bucket4j.runtime.BucketPodStorageRecorder;
import io.quarkiverse.bucket4j.runtime.DefaultProxyManagerProducer;
import io.quarkiverse.bucket4j.runtime.MethodDescription;
import io.quarkiverse.bucket4j.runtime.RateLimitException;
import io.quarkiverse.bucket4j.runtime.RateLimitExceptionMapper;
import io.quarkiverse.bucket4j.runtime.RateLimited;
import io.quarkiverse.bucket4j.runtime.RateLimitedInterceptor;
import io.quarkiverse.bucket4j.runtime.resolver.ConstantResolver;
import io.quarkiverse.bucket4j.runtime.resolver.IdentityResolver;
import io.quarkiverse.bucket4j.runtime.resolver.IpResolver;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

class Bucket4jProcessor {
    public static final DotName RATE_LIMITED_INTERCEPTOR = DotName.createSimple((String)RateLimitedInterceptor.class.getName());
    public static final DotName RATE_LIMITED = DotName.createSimple((String)RateLimited.class.getName());
    public static final DotName IDENTITY_RESOLVER = DotName.createSimple((String)IdentityResolver.class.getName());
    private static final String FEATURE = "bucket4j";

    Bucket4jProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem caffeineProxyManager() {
        return AdditionalBeanBuildItem.unremovableOf(DefaultProxyManagerProducer.class);
    }

    @BuildStep
    AdditionalBeanBuildItem interceptorBinding() {
        return AdditionalBeanBuildItem.unremovableOf(RateLimitedInterceptor.class);
    }

    @BuildStep
    AdditionalBeanBuildItem constantResolver() {
        return AdditionalBeanBuildItem.unremovableOf(ConstantResolver.class);
    }

    @BuildStep
    void exceptionMapper(BuildProducer<ResteasyJaxrsProviderBuildItem> resteasyJaxrsProviderBuildItemBuildProducer, BuildProducer<ExceptionMapperBuildItem> exceptionMapperBuildItemBuildProducer) {
        resteasyJaxrsProviderBuildItemBuildProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(RateLimitExceptionMapper.class.getName()));
        exceptionMapperBuildItemBuildProducer.produce((BuildItem)new ExceptionMapperBuildItem(RateLimitExceptionMapper.class.getName(), RateLimitException.class.getName(), Integer.valueOf(5100), false));
    }

    @BuildStep
    void ipResolver(Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (capabilities.isPresent("io.quarkus.vertx.http")) {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(IpResolver.class));
        }
    }

    @BuildStep
    UnremovableBeanBuildItem unremovableIdentityResolvers() {
        return UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{IDENTITY_RESOLVER});
    }

    @BuildStep
    void gatherRateLimitCheck(BeanArchiveIndexBuildItem beanArchiveBuildItem, BuildProducer<RateLimitCheckBuildItem> producer) {
        AnnotationTarget target;
        Collection instances = beanArchiveBuildItem.getIndex().getAnnotations(RATE_LIMITED);
        HashMap<MethodDescription, RateLimitCheckBuildItem> visited = new HashMap<MethodDescription, RateLimitCheckBuildItem>();
        for (AnnotationInstance instance : instances) {
            target = instance.target();
            if (target.kind() != AnnotationTarget.Kind.METHOD) continue;
            this.visit(visited, instance, target.asMethod());
        }
        for (AnnotationInstance instance : instances) {
            target = instance.target();
            if (target.kind() != AnnotationTarget.Kind.CLASS || RATE_LIMITED_INTERCEPTOR.equals((Object)target.asClass().name())) continue;
            List methods = target.asClass().methods();
            for (MethodInfo methodInfo : methods) {
                this.visit(visited, instance, methodInfo);
            }
        }
        visited.values().forEach(arg_0 -> producer.produce(arg_0));
    }

    private void visit(Map<MethodDescription, RateLimitCheckBuildItem> visited, AnnotationInstance instance, MethodInfo methodInfo) {
        visited.computeIfAbsent(this.createDescription(methodInfo), md -> new RateLimitCheckBuildItem((MethodDescription)md, instance.value("bucket").asString(), this.getIdentityResolver(instance)));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createBucketPodStorage(BucketPodStorageRecorder recorder, List<RateLimitCheckBuildItem> rateLimitChecks, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        rateLimitChecks.forEach(item -> recorder.registerMethod(item.getMethodDescription(), item.getBucket(), item.getIdentityResolver()));
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(BucketPodStorage.class).scope(ApplicationScoped.class)).unremovable()).runtimeProxy((Object)recorder.create()).setRuntimeInit().done());
    }

    private String getIdentityResolver(AnnotationInstance instance) {
        return Optional.ofNullable(instance.value("identityResolver")).map(AnnotationValue::asString).orElse(null);
    }

    private MethodDescription createDescription(MethodInfo method) {
        String[] params = new String[method.parametersCount()];
        for (int i = 0; i < method.parametersCount(); ++i) {
            params[i] = method.parameterType(i).name().toString();
        }
        return new MethodDescription(method.declaringClass().name().toString(), method.name(), params);
    }
}

