/*
 * Decompiled with CFR 0.152.
 */
package io.qdrant.client;

import io.qdrant.client.grpc.Points;
import java.util.ArrayList;
import java.util.List;

public final class VectorOutputHelper {
    private VectorOutputHelper() {
    }

    public static Points.DenseVector getDenseVector(Points.VectorOutput vectorOutput) {
        if (vectorOutput == null) {
            return null;
        }
        List<Float> data = vectorOutput.getDataList();
        if (!data.isEmpty()) {
            return Points.DenseVector.newBuilder().addAllData(data).build();
        }
        if (vectorOutput.hasDense()) {
            return vectorOutput.getDense();
        }
        return null;
    }

    public static Points.SparseVector getSparseVector(Points.VectorOutput vectorOutput) {
        if (vectorOutput == null) {
            return null;
        }
        List<Float> data = vectorOutput.getDataList();
        if (!data.isEmpty() && vectorOutput.hasIndices()) {
            Points.SparseIndices indices = vectorOutput.getIndices();
            return Points.SparseVector.newBuilder().addAllValues(data).addAllIndices(indices.getDataList()).build();
        }
        if (vectorOutput.hasSparse()) {
            return vectorOutput.getSparse();
        }
        return null;
    }

    public static Points.MultiDenseVector getMultiVector(Points.VectorOutput vectorOutput) {
        int vectorsCount;
        if (vectorOutput == null) {
            return null;
        }
        List<Float> data = vectorOutput.getDataList();
        if (!data.isEmpty() && (vectorsCount = vectorOutput.getVectorsCount()) > 0) {
            int vectorSize = data.size() / vectorsCount;
            ArrayList<Points.DenseVector> vectors = new ArrayList<Points.DenseVector>(vectorsCount);
            for (int i = 0; i < vectorsCount; ++i) {
                int start = i * vectorSize;
                int end = start + vectorSize;
                List<Float> vectorData = data.subList(start, end);
                vectors.add(Points.DenseVector.newBuilder().addAllData(vectorData).build());
            }
            return Points.MultiDenseVector.newBuilder().addAllVectors(vectors).build();
        }
        if (vectorOutput.hasMultiDense()) {
            return vectorOutput.getMultiDense();
        }
        return null;
    }
}

