/*
 * Decompiled with CFR 0.152.
 */
package io.qdrant.client;

import io.qdrant.client.grpc.Common;
import java.util.List;

public final class ConditionFactory {
    private ConditionFactory() {
    }

    public static Common.Condition hasId(Common.PointId id) {
        return Common.Condition.newBuilder().setHasId(Common.HasIdCondition.newBuilder().addHasId(id).build()).build();
    }

    public static Common.Condition hasId(List<Common.PointId> ids) {
        return Common.Condition.newBuilder().setHasId(Common.HasIdCondition.newBuilder().addAllHasId(ids).build()).build();
    }

    public static Common.Condition isEmpty(String field) {
        return Common.Condition.newBuilder().setIsEmpty(Common.IsEmptyCondition.newBuilder().setKey(field).build()).build();
    }

    public static Common.Condition isNull(String field) {
        return Common.Condition.newBuilder().setIsNull(Common.IsNullCondition.newBuilder().setKey(field).build()).build();
    }

    public static Common.Condition matchKeyword(String field, String keyword) {
        return Common.Condition.newBuilder().setField(Common.FieldCondition.newBuilder().setKey(field).setMatch(Common.Match.newBuilder().setKeyword(keyword).build()).build()).build();
    }

    public static Common.Condition matchText(String field, String text) {
        return Common.Condition.newBuilder().setField(Common.FieldCondition.newBuilder().setKey(field).setMatch(Common.Match.newBuilder().setText(text).build()).build()).build();
    }

    public static Common.Condition matchPhrase(String field, String phrase) {
        return Common.Condition.newBuilder().setField(Common.FieldCondition.newBuilder().setKey(field).setMatch(Common.Match.newBuilder().setPhrase(phrase).build()).build()).build();
    }

    public static Common.Condition matchTextAny(String field, String textAny) {
        return Common.Condition.newBuilder().setField(Common.FieldCondition.newBuilder().setKey(field).setMatch(Common.Match.newBuilder().setTextAny(textAny).build()).build()).build();
    }

    public static Common.Condition match(String field, boolean value) {
        return Common.Condition.newBuilder().setField(Common.FieldCondition.newBuilder().setKey(field).setMatch(Common.Match.newBuilder().setBoolean(value).build()).build()).build();
    }

    public static Common.Condition match(String field, long value) {
        return Common.Condition.newBuilder().setField(Common.FieldCondition.newBuilder().setKey(field).setMatch(Common.Match.newBuilder().setInteger(value).build()).build()).build();
    }

    public static Common.Condition matchKeywords(String field, List<String> keywords) {
        return Common.Condition.newBuilder().setField(Common.FieldCondition.newBuilder().setKey(field).setMatch(Common.Match.newBuilder().setKeywords(Common.RepeatedStrings.newBuilder().addAllStrings(keywords).build()).build()).build()).build();
    }

    public static Common.Condition matchValues(String field, List<Long> values) {
        return Common.Condition.newBuilder().setField(Common.FieldCondition.newBuilder().setKey(field).setMatch(Common.Match.newBuilder().setIntegers(Common.RepeatedIntegers.newBuilder().addAllIntegers(values).build()).build()).build()).build();
    }

    public static Common.Condition matchExceptKeywords(String field, List<String> keywords) {
        return Common.Condition.newBuilder().setField(Common.FieldCondition.newBuilder().setKey(field).setMatch(Common.Match.newBuilder().setExceptKeywords(Common.RepeatedStrings.newBuilder().addAllStrings(keywords).build()).build()).build()).build();
    }

    public static Common.Condition matchExceptValues(String field, List<Long> values) {
        return Common.Condition.newBuilder().setField(Common.FieldCondition.newBuilder().setKey(field).setMatch(Common.Match.newBuilder().setExceptIntegers(Common.RepeatedIntegers.newBuilder().addAllIntegers(values).build()).build()).build()).build();
    }

    public static Common.Condition nested(String field, Common.Condition condition) {
        return Common.Condition.newBuilder().setNested(Common.NestedCondition.newBuilder().setKey(field).setFilter(Common.Filter.newBuilder().addMust(condition).build()).build()).build();
    }

    public static Common.Condition nested(String field, Common.Filter filter) {
        return Common.Condition.newBuilder().setNested(Common.NestedCondition.newBuilder().setKey(field).setFilter(filter)).build();
    }

    public static Common.Condition range(String field, Common.Range range) {
        return Common.Condition.newBuilder().setField(Common.FieldCondition.newBuilder().setKey(field).setRange(range).build()).build();
    }

    public static Common.Condition geoRadius(String field, double latitude, double longitude, float radius) {
        return Common.Condition.newBuilder().setField(Common.FieldCondition.newBuilder().setKey(field).setGeoRadius(Common.GeoRadius.newBuilder().setCenter(Common.GeoPoint.newBuilder().setLat(latitude).setLon(longitude).build()).setRadius(radius).build()).build()).build();
    }

    public static Common.Condition geoBoundingBox(String field, double topLeftLatitude, double topLeftLongitude, double bottomRightLatitude, double bottomRightLongitude) {
        return Common.Condition.newBuilder().setField(Common.FieldCondition.newBuilder().setKey(field).setGeoBoundingBox(Common.GeoBoundingBox.newBuilder().setTopLeft(Common.GeoPoint.newBuilder().setLat(topLeftLatitude).setLon(topLeftLongitude).build()).setBottomRight(Common.GeoPoint.newBuilder().setLat(bottomRightLatitude).setLon(bottomRightLongitude).build()).build()).build()).build();
    }

    public static Common.Condition geoPolygon(String field, Common.GeoLineString exterior, List<Common.GeoLineString> interiors) {
        Common.GeoPolygon.Builder geoPolygonBuilder = Common.GeoPolygon.newBuilder().setExterior(exterior);
        if (!interiors.isEmpty()) {
            geoPolygonBuilder.addAllInteriors(interiors);
        }
        return Common.Condition.newBuilder().setField(Common.FieldCondition.newBuilder().setKey(field).setGeoPolygon(geoPolygonBuilder.build()).build()).build();
    }

    public static Common.Condition valuesCount(String field, Common.ValuesCount valuesCount) {
        return Common.Condition.newBuilder().setField(Common.FieldCondition.newBuilder().setKey(field).setValuesCount(valuesCount).build()).build();
    }

    public static Common.Condition filter(Common.Filter filter) {
        return Common.Condition.newBuilder().setFilter(filter).build();
    }

    public static Common.Condition datetimeRange(String field, Common.DatetimeRange datetimeRange) {
        return Common.Condition.newBuilder().setField(Common.FieldCondition.newBuilder().setKey(field).setDatetimeRange(datetimeRange).build()).build();
    }

    public static Common.Condition hasVector(String vector) {
        return Common.Condition.newBuilder().setHasVector(Common.HasVectorCondition.newBuilder().setHasVector(vector).build()).build();
    }
}

