/*
 * Decompiled with CFR 0.152.
 */
package io.qdrant.client;

import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.Deadline;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.qdrant.client.ApiKeyCredentials;
import io.qdrant.client.VersionsCompatibilityChecker;
import io.qdrant.client.grpc.CollectionsGrpc;
import io.qdrant.client.grpc.PointsGrpc;
import io.qdrant.client.grpc.QdrantGrpc;
import io.qdrant.client.grpc.QdrantOuterClass;
import io.qdrant.client.grpc.SnapshotsGrpc;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QdrantGrpcClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(QdrantGrpcClient.class);
    @Nullable
    private final CallCredentials callCredentials;
    private final ManagedChannel channel;
    private final boolean shutdownChannelOnClose;
    @Nullable
    private final Duration timeout;

    QdrantGrpcClient(ManagedChannel channel, boolean shutdownChannelOnClose, @Nullable CallCredentials callCredentials, @Nullable Duration timeout) {
        this.callCredentials = callCredentials;
        this.channel = channel;
        this.shutdownChannelOnClose = shutdownChannelOnClose;
        this.timeout = timeout;
    }

    public static Builder newBuilder(ManagedChannel channel) {
        return new Builder(channel, false, true);
    }

    public static Builder newBuilder(ManagedChannel channel, boolean shutdownChannelOnClose) {
        return new Builder(channel, shutdownChannelOnClose, true);
    }

    public static Builder newBuilder(ManagedChannel channel, boolean shutdownChannelOnClose, boolean checkCompatibility) {
        return new Builder(channel, shutdownChannelOnClose, checkCompatibility);
    }

    public static Builder newBuilder(String host) {
        return new Builder(host, 6334, true, true);
    }

    public static Builder newBuilder(String host, int port) {
        return new Builder(host, port, true, true);
    }

    public static Builder newBuilder(String host, int port, boolean useTransportLayerSecurity) {
        return new Builder(host, port, useTransportLayerSecurity, true);
    }

    public static Builder newBuilder(String host, int port, boolean useTransportLayerSecurity, boolean checkCompatibility) {
        return new Builder(host, port, useTransportLayerSecurity, checkCompatibility);
    }

    public ManagedChannel channel() {
        return this.channel;
    }

    public QdrantGrpc.QdrantFutureStub qdrant() {
        return (QdrantGrpc.QdrantFutureStub)((QdrantGrpc.QdrantFutureStub)QdrantGrpc.newFutureStub((Channel)this.channel).withCallCredentials(this.callCredentials)).withDeadline(this.timeout != null ? Deadline.after((long)this.timeout.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS) : null);
    }

    public PointsGrpc.PointsFutureStub points() {
        return (PointsGrpc.PointsFutureStub)((PointsGrpc.PointsFutureStub)PointsGrpc.newFutureStub((Channel)this.channel).withCallCredentials(this.callCredentials)).withDeadline(this.timeout != null ? Deadline.after((long)this.timeout.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS) : null);
    }

    public CollectionsGrpc.CollectionsFutureStub collections() {
        return (CollectionsGrpc.CollectionsFutureStub)((CollectionsGrpc.CollectionsFutureStub)CollectionsGrpc.newFutureStub((Channel)this.channel).withCallCredentials(this.callCredentials)).withDeadline(this.timeout != null ? Deadline.after((long)this.timeout.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS) : null);
    }

    public SnapshotsGrpc.SnapshotsFutureStub snapshots() {
        return (SnapshotsGrpc.SnapshotsFutureStub)((SnapshotsGrpc.SnapshotsFutureStub)SnapshotsGrpc.newFutureStub((Channel)this.channel).withCallCredentials(this.callCredentials)).withDeadline(this.timeout != null ? Deadline.after((long)this.timeout.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS) : null);
    }

    @Override
    public void close() {
        if (this.shutdownChannelOnClose && !this.channel.isShutdown() && !this.channel.isTerminated()) {
            try {
                this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("exception thrown when shutting down channel", (Throwable)e);
            }
        }
    }

    public static class Builder {
        private final ManagedChannel channel;
        private final boolean shutdownChannelOnClose;
        @Nullable
        private CallCredentials callCredentials;
        @Nullable
        private Duration timeout;

        Builder(ManagedChannel channel, boolean shutdownChannelOnClose, boolean checkCompatibility) {
            this.channel = channel;
            this.shutdownChannelOnClose = shutdownChannelOnClose;
            String clientVersion = Builder.class.getPackage().getImplementationVersion();
            if (checkCompatibility) {
                this.checkVersionsCompatibility(clientVersion);
            }
        }

        Builder(String host, int port, boolean useTransportLayerSecurity, boolean checkCompatibility) {
            String clientVersion = Builder.class.getPackage().getImplementationVersion();
            String javaVersion = System.getProperty("java.version");
            String userAgent = "java-client/" + clientVersion + " java/" + javaVersion;
            this.channel = Builder.createChannel(host, port, useTransportLayerSecurity, userAgent);
            this.shutdownChannelOnClose = true;
            if (checkCompatibility) {
                this.checkVersionsCompatibility(clientVersion);
            }
        }

        public Builder withApiKey(String apiKey) {
            this.callCredentials = new ApiKeyCredentials(apiKey);
            return this;
        }

        public Builder withTimeout(@Nullable Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder withCallCredentials(@Nullable CallCredentials callCredentials) {
            this.callCredentials = callCredentials;
            return this;
        }

        public QdrantGrpcClient build() {
            return new QdrantGrpcClient(this.channel, this.shutdownChannelOnClose, this.callCredentials, this.timeout);
        }

        private static ManagedChannel createChannel(String host, int port, boolean useTransportLayerSecurity, String userAgent) {
            ManagedChannelBuilder channelBuilder = ManagedChannelBuilder.forAddress((String)host, (int)port);
            if (useTransportLayerSecurity) {
                channelBuilder.useTransportSecurity();
            } else {
                channelBuilder.usePlaintext();
            }
            channelBuilder.userAgent(userAgent);
            return channelBuilder.build();
        }

        private void checkVersionsCompatibility(String clientVersion) {
            try {
                String serverVersion = QdrantGrpc.newBlockingStub((Channel)this.channel).healthCheck(QdrantOuterClass.HealthCheckRequest.getDefaultInstance()).getVersion();
                if (!VersionsCompatibilityChecker.isCompatible(clientVersion, serverVersion)) {
                    String logMessage = "Qdrant client version " + clientVersion + " is incompatible with server version " + serverVersion + ". Major versions should match and minor version difference must not exceed 1. Set checkCompatibility=false to skip version check.";
                    logger.warn(logMessage);
                }
            }
            catch (Exception e) {
                logger.warn("Failed to obtain server version. Unable to check client-server compatibility. Set checkCompatibility=false to skip version check.");
            }
        }
    }
}

