/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.maven;

import io.qameta.allure.maven.AllureCommandline;
import io.qameta.allure.maven.DownloadUtils;
import io.qameta.allure.maven.ProxyUtils;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;

@Mojo(name="install", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class AllureInstallMojo
extends AbstractMojo {
    @Parameter(property="report.version")
    private String reportVersion;
    @Parameter(property="allure.download.url")
    private String allureDownloadUrl;
    @Parameter(property="allure.install.directory", defaultValue="${project.basedir}/.allure")
    private String installDirectory;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;
    @Component
    private DependencyResolver dependencyResolver;

    public void execute() throws MojoExecutionException {
        try {
            AllureCommandline commandline = new AllureCommandline(Paths.get(this.installDirectory, new String[0]), this.reportVersion);
            this.getLog().info((CharSequence)String.format("Allure installation directory %s", this.installDirectory));
            this.getLog().info((CharSequence)String.format("Try to finding out allure %s", commandline.getVersion()));
            if (commandline.allureNotExists()) {
                String downloadUrl = DownloadUtils.getAllureDownloadUrl(commandline.getVersion(), this.allureDownloadUrl);
                if (downloadUrl == null) {
                    commandline.downloadWithMaven(this.session, this.dependencyResolver);
                } else {
                    this.getLog().info((CharSequence)("Downloading allure commandline from " + downloadUrl));
                    commandline.download(downloadUrl, ProxyUtils.getProxy(this.session, this.decrypter));
                    this.getLog().info((CharSequence)"Downloading allure commandline complete");
                }
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Installation error", (Throwable)e);
            throw new MojoExecutionException("Can't install allure", (Exception)e);
        }
    }
}

