/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.listener;

import io.qameta.allure.listener.ContainerLifecycleListener;
import io.qameta.allure.listener.FixtureLifecycleListener;
import io.qameta.allure.listener.LifecycleListener;
import io.qameta.allure.listener.StepLifecycleListener;
import io.qameta.allure.listener.TestLifecycleListener;
import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleNotifier
implements ContainerLifecycleListener,
TestLifecycleListener,
FixtureLifecycleListener,
StepLifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleNotifier.class);
    private final List<ContainerLifecycleListener> containerListeners;
    private final List<TestLifecycleListener> testListeners;
    private final List<FixtureLifecycleListener> fixtureListeners;
    private final List<StepLifecycleListener> stepListeners;

    public LifecycleNotifier(List<ContainerLifecycleListener> containerListeners, List<TestLifecycleListener> testListeners, List<FixtureLifecycleListener> fixtureListeners, List<StepLifecycleListener> stepListeners) {
        this.containerListeners = containerListeners;
        this.testListeners = testListeners;
        this.fixtureListeners = fixtureListeners;
        this.stepListeners = stepListeners;
    }

    @Override
    public void beforeTestSchedule(TestResult result) {
        this.runSafely(this.testListeners, TestLifecycleListener::beforeTestSchedule, result);
    }

    @Override
    public void afterTestSchedule(TestResult result) {
        this.runSafely(this.testListeners, TestLifecycleListener::afterTestSchedule, result);
    }

    @Override
    public void beforeTestUpdate(TestResult result) {
        this.runSafely(this.testListeners, TestLifecycleListener::beforeTestUpdate, result);
    }

    @Override
    public void afterTestUpdate(TestResult result) {
        this.runSafely(this.testListeners, TestLifecycleListener::afterTestUpdate, result);
    }

    @Override
    public void beforeTestStart(TestResult result) {
        this.runSafely(this.testListeners, TestLifecycleListener::beforeTestStart, result);
    }

    @Override
    public void afterTestStart(TestResult result) {
        this.runSafely(this.testListeners, TestLifecycleListener::afterTestStart, result);
    }

    @Override
    public void beforeTestStop(TestResult result) {
        this.runSafely(this.testListeners, TestLifecycleListener::beforeTestStop, result);
    }

    @Override
    public void afterTestStop(TestResult result) {
        this.runSafely(this.testListeners, TestLifecycleListener::afterTestStop, result);
    }

    @Override
    public void beforeTestWrite(TestResult result) {
        this.runSafely(this.testListeners, TestLifecycleListener::beforeTestWrite, result);
    }

    @Override
    public void afterTestWrite(TestResult result) {
        this.runSafely(this.testListeners, TestLifecycleListener::afterTestWrite, result);
    }

    @Override
    public void beforeContainerStart(TestResultContainer container) {
        this.runSafely(this.containerListeners, ContainerLifecycleListener::beforeContainerStart, container);
    }

    @Override
    public void afterContainerStart(TestResultContainer container) {
        this.runSafely(this.containerListeners, ContainerLifecycleListener::afterContainerStart, container);
    }

    @Override
    public void beforeContainerUpdate(TestResultContainer container) {
        this.runSafely(this.containerListeners, ContainerLifecycleListener::beforeContainerUpdate, container);
    }

    @Override
    public void afterContainerUpdate(TestResultContainer container) {
        this.runSafely(this.containerListeners, ContainerLifecycleListener::afterContainerUpdate, container);
    }

    @Override
    public void beforeContainerStop(TestResultContainer container) {
        this.runSafely(this.containerListeners, ContainerLifecycleListener::beforeContainerStop, container);
    }

    @Override
    public void afterContainerStop(TestResultContainer container) {
        this.runSafely(this.containerListeners, ContainerLifecycleListener::afterContainerStop, container);
    }

    @Override
    public void beforeContainerWrite(TestResultContainer container) {
        this.runSafely(this.containerListeners, ContainerLifecycleListener::beforeContainerWrite, container);
    }

    @Override
    public void afterContainerWrite(TestResultContainer container) {
        this.runSafely(this.containerListeners, ContainerLifecycleListener::afterContainerWrite, container);
    }

    @Override
    public void beforeFixtureStart(FixtureResult result) {
        this.runSafely(this.fixtureListeners, FixtureLifecycleListener::beforeFixtureStart, result);
    }

    @Override
    public void afterFixtureStart(FixtureResult result) {
        this.runSafely(this.fixtureListeners, FixtureLifecycleListener::afterFixtureStart, result);
    }

    @Override
    public void beforeFixtureUpdate(FixtureResult result) {
        this.runSafely(this.fixtureListeners, FixtureLifecycleListener::beforeFixtureUpdate, result);
    }

    @Override
    public void afterFixtureUpdate(FixtureResult result) {
        this.runSafely(this.fixtureListeners, FixtureLifecycleListener::afterFixtureUpdate, result);
    }

    @Override
    public void beforeFixtureStop(FixtureResult result) {
        this.runSafely(this.fixtureListeners, FixtureLifecycleListener::beforeFixtureStop, result);
    }

    @Override
    public void afterFixtureStop(FixtureResult result) {
        this.runSafely(this.fixtureListeners, FixtureLifecycleListener::afterFixtureStop, result);
    }

    @Override
    public void beforeStepStart(StepResult result) {
        this.runSafely(this.stepListeners, StepLifecycleListener::beforeStepStart, result);
    }

    @Override
    public void afterStepStart(StepResult result) {
        this.runSafely(this.stepListeners, StepLifecycleListener::afterStepStart, result);
    }

    @Override
    public void beforeStepUpdate(StepResult result) {
        this.runSafely(this.stepListeners, StepLifecycleListener::beforeStepUpdate, result);
    }

    @Override
    public void afterStepUpdate(StepResult result) {
        this.runSafely(this.stepListeners, StepLifecycleListener::afterStepUpdate, result);
    }

    @Override
    public void beforeStepStop(StepResult result) {
        this.runSafely(this.stepListeners, StepLifecycleListener::beforeStepStop, result);
    }

    @Override
    public void afterStepStop(StepResult result) {
        this.runSafely(this.stepListeners, StepLifecycleListener::afterStepStop, result);
    }

    protected <T extends LifecycleListener, S> void runSafely(List<T> listeners, BiConsumer<T, S> method, S object) {
        listeners.forEach(listener -> {
            try {
                method.accept(listener, object);
            }
            catch (Exception e) {
                LOGGER.error("Could not invoke listener method", (Throwable)e);
            }
        });
    }
}

