/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.spring.web;

import io.prometheus.client.Summary;
import io.prometheus.client.spring.web.PrometheusTimeMethod;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;

@Aspect(value="pertarget(io.prometheus.client.spring.web.MethodTimer.timeable())")
@Scope(value="prototype")
@ControllerAdvice
public class MethodTimer {
    private final ReadWriteLock summaryLock = new ReentrantReadWriteLock();
    private final HashMap<String, Summary> summaries = new HashMap();

    @Pointcut(value="@annotation(io.prometheus.client.spring.web.PrometheusTimeMethod)")
    public void annotatedMethod() {
    }

    @Pointcut(value="annotatedMethod()")
    public void timeable() {
    }

    private PrometheusTimeMethod getAnnotation(ProceedingJoinPoint pjp) throws NoSuchMethodException {
        assert (pjp.getSignature() instanceof MethodSignature);
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        PrometheusTimeMethod annot = (PrometheusTimeMethod)AnnotationUtils.findAnnotation(pjp.getTarget().getClass(), PrometheusTimeMethod.class);
        if (annot != null) {
            return annot;
        }
        String name = signature.getName();
        Class[] parameterTypes = signature.getParameterTypes();
        Method method = ReflectionUtils.findMethod(pjp.getTarget().getClass(), (String)name, (Class[])parameterTypes);
        return (PrometheusTimeMethod)AnnotationUtils.findAnnotation((Method)method, PrometheusTimeMethod.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Summary ensureSummary(ProceedingJoinPoint pjp, String key) throws IllegalStateException {
        PrometheusTimeMethod annot;
        try {
            annot = this.getAnnotation(pjp);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Annotation could not be found for pjp \"" + pjp.toShortString() + "\"", e);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Annotation could not be found for pjp \"" + pjp.toShortString() + "\"", e);
        }
        assert (annot != null);
        Lock writeLock = this.summaryLock.writeLock();
        writeLock.lock();
        try {
            Summary summary = this.summaries.get(key);
            if (summary != null) {
                Summary summary2 = summary;
                return summary2;
            }
            summary = (Summary)((Summary.Builder)((Summary.Builder)Summary.build().name(annot.name())).help(annot.help())).register();
            this.summaries.put(key, summary);
            Summary summary3 = summary;
            return summary3;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="timeable()")
    public Object timeMethod(ProceedingJoinPoint pjp) throws Throwable {
        Summary summary;
        String key = pjp.getSignature().toLongString();
        Lock r = this.summaryLock.readLock();
        r.lock();
        try {
            summary = this.summaries.get(key);
        }
        finally {
            r.unlock();
        }
        if (summary == null) {
            summary = this.ensureSummary(pjp, key);
        }
        Summary.Timer t = summary.startTimer();
        try {
            Object object = pjp.proceed();
            return object;
        }
        finally {
            t.observeDuration();
        }
    }
}

