/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.spring.boot;

import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.stereotype.Component;

@Component
public class SpringBootMetricsCollector
extends Collector
implements Collector.Describable {
    private final Collection<PublicMetrics> publicMetrics;

    @Autowired
    public SpringBootMetricsCollector(Collection<PublicMetrics> publicMetrics) {
        this.publicMetrics = publicMetrics;
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> samples = new ArrayList<Collector.MetricFamilySamples>();
        for (PublicMetrics publicMetrics : this.publicMetrics) {
            for (Metric metric : publicMetrics.metrics()) {
                String name = Collector.sanitizeMetricName((String)metric.getName());
                double value = metric.getValue().doubleValue();
                Collector.MetricFamilySamples metricFamilySamples = new Collector.MetricFamilySamples(name, Collector.Type.GAUGE, name, Collections.singletonList(new Collector.MetricFamilySamples.Sample(name, Collections.emptyList(), Collections.emptyList(), value)));
                samples.add(metricFamilySamples);
            }
        }
        return samples;
    }

    public List<Collector.MetricFamilySamples> describe() {
        return new ArrayList<Collector.MetricFamilySamples>();
    }
}

