/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.pushgateway;

import io.prometheus.metrics.config.EscapingScheme;
import io.prometheus.metrics.config.ExporterPushgatewayProperties;
import io.prometheus.metrics.config.PrometheusProperties;
import io.prometheus.metrics.config.PrometheusPropertiesException;
import io.prometheus.metrics.exporter.pushgateway.DefaultHttpConnectionFactory;
import io.prometheus.metrics.exporter.pushgateway.DefaultJobLabelDetector;
import io.prometheus.metrics.exporter.pushgateway.Format;
import io.prometheus.metrics.exporter.pushgateway.HttpConnectionFactory;
import io.prometheus.metrics.exporter.pushgateway.Scheme;
import io.prometheus.metrics.expositionformats.ExpositionFormatWriter;
import io.prometheus.metrics.expositionformats.PrometheusProtobufWriter;
import io.prometheus.metrics.expositionformats.PrometheusTextFormatWriter;
import io.prometheus.metrics.model.registry.Collector;
import io.prometheus.metrics.model.registry.MultiCollector;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.model.snapshots.PrometheusNaming;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class PushGateway {
    private final URL url;
    private final ExpositionFormatWriter writer;
    private final boolean prometheusTimestampsInMs;
    private final Map<String, String> requestHeaders;
    private final PrometheusRegistry registry;
    private final HttpConnectionFactory connectionFactory;
    private final EscapingScheme escapingScheme;
    private final Duration connectionTimeout;
    private final Duration readTimeout;

    private PushGateway(PrometheusRegistry registry, Format format, URL url, HttpConnectionFactory connectionFactory, Map<String, String> requestHeaders, boolean prometheusTimestampsInMs, EscapingScheme escapingScheme, Duration connectionTimeout, Duration readTimeout) {
        this.registry = registry;
        this.url = url;
        this.requestHeaders = Collections.unmodifiableMap(new HashMap<String, String>(requestHeaders));
        this.connectionFactory = connectionFactory;
        this.prometheusTimestampsInMs = prometheusTimestampsInMs;
        this.escapingScheme = escapingScheme;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.writer = this.getWriter(format);
        if (!this.writer.isAvailable()) {
            throw new RuntimeException(this.writer.getClass() + " is not available");
        }
    }

    private ExpositionFormatWriter getWriter(Format format) {
        if (format == Format.PROMETHEUS_TEXT) {
            return PrometheusTextFormatWriter.builder().setTimestampsInMs(this.prometheusTimestampsInMs).build();
        }
        return new PrometheusProtobufWriter();
    }

    public void push() throws IOException {
        this.doRequest(this.registry, "PUT");
    }

    public void push(Collector collector) throws IOException {
        PrometheusRegistry registry = new PrometheusRegistry();
        registry.register(collector);
        this.doRequest(registry, "PUT");
    }

    public void push(MultiCollector collector) throws IOException {
        PrometheusRegistry registry = new PrometheusRegistry();
        registry.register(collector);
        this.doRequest(registry, "PUT");
    }

    public void pushAdd() throws IOException {
        this.doRequest(this.registry, "POST");
    }

    public void pushAdd(Collector collector) throws IOException {
        PrometheusRegistry registry = new PrometheusRegistry();
        registry.register(collector);
        this.doRequest(registry, "POST");
    }

    public void pushAdd(MultiCollector collector) throws IOException {
        PrometheusRegistry registry = new PrometheusRegistry();
        registry.register(collector);
        this.doRequest(registry, "POST");
    }

    public void delete() throws IOException {
        this.doRequest(null, "DELETE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(@Nullable PrometheusRegistry registry, String method) throws IOException {
        try {
            HttpURLConnection connection = this.connectionFactory.create(this.url);
            this.requestHeaders.forEach(connection::setRequestProperty);
            connection.setRequestProperty("Content-Type", this.writer.getContentType());
            if (!method.equals("DELETE")) {
                connection.setDoOutput(true);
            }
            connection.setRequestMethod(method);
            connection.setConnectTimeout((int)this.connectionTimeout.toMillis());
            connection.setReadTimeout((int)this.readTimeout.toMillis());
            connection.connect();
            try {
                int response;
                if (!method.equals("DELETE")) {
                    OutputStream outputStream = connection.getOutputStream();
                    this.writer.write(outputStream, Objects.requireNonNull(registry).scrape(), this.escapingScheme);
                    outputStream.flush();
                    outputStream.close();
                }
                if ((response = connection.getResponseCode()) / 100 != 2) {
                    String errorMessage;
                    InputStream errorStream = connection.getErrorStream();
                    if (errorStream != null) {
                        String errBody = PushGateway.readFromStream(errorStream);
                        errorMessage = "Response code from " + this.url + " was " + response + ", response body: " + errBody;
                    } else {
                        errorMessage = "Response code from " + this.url + " was " + response;
                    }
                    throw new IOException(errorMessage);
                }
            }
            finally {
                connection.disconnect();
            }
        }
        catch (IOException e) {
            String baseUrl = this.url.getProtocol() + "://" + this.url.getHost();
            if (this.url.getPort() != -1) {
                baseUrl = baseUrl + ":" + this.url.getPort();
            }
            throw new IOException("Failed to push metrics to the Prometheus Pushgateway on " + baseUrl + ": " + e.getMessage(), e);
        }
    }

    private static String readFromStream(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }

    public static Builder builder() {
        return PushGateway.builder(PrometheusProperties.get());
    }

    public static Builder builder(PrometheusProperties config) {
        return new Builder(config);
    }

    public static class Builder {
        private final PrometheusProperties config;
        @Nullable
        private Format format;
        @Nullable
        private String address;
        @Nullable
        private Scheme scheme;
        @Nullable
        private String job;
        @Nullable
        private Duration connectionTimeout;
        @Nullable
        private Duration readTimeout;
        private boolean prometheusTimestampsInMs;
        private final Map<String, String> requestHeaders = new HashMap<String, String>();
        private PrometheusRegistry registry = PrometheusRegistry.defaultRegistry;
        private HttpConnectionFactory connectionFactory = new DefaultHttpConnectionFactory();
        private final Map<String, String> groupingKey = new TreeMap<String, String>();
        @Nullable
        private EscapingScheme escapingScheme;

        private Builder(PrometheusProperties config) {
            this.config = config;
        }

        public Builder format(Format format) {
            this.format = Objects.requireNonNull(format, "format must not be null");
            return this;
        }

        public Builder address(String address) {
            this.address = Objects.requireNonNull(address, "address must not be null");
            return this;
        }

        public Builder basicAuth(String user, String password) {
            byte[] credentialsBytes = (Objects.requireNonNull(user, "user must not be null") + ":" + Objects.requireNonNull(password, "password must not be null")).getBytes(StandardCharsets.UTF_8);
            String encoded = Base64.getEncoder().encodeToString(credentialsBytes);
            this.requestHeaders.put("Authorization", String.format("Basic %s", encoded));
            return this;
        }

        public Builder bearerToken(String token) {
            this.requestHeaders.put("Authorization", String.format("Bearer %s", Objects.requireNonNull(token, "token must not be null")));
            return this;
        }

        public Builder scheme(Scheme scheme) {
            this.scheme = Objects.requireNonNull(scheme, "scheme must not be null");
            return this;
        }

        public Builder connectionFactory(HttpConnectionFactory connectionFactory) {
            this.connectionFactory = Objects.requireNonNull(connectionFactory, "connectionFactory must not be null");
            return this;
        }

        public Builder job(String job) {
            this.job = Objects.requireNonNull(job, "job must not be null");
            return this;
        }

        public Builder groupingKey(String name, String value) {
            this.groupingKey.put(Objects.requireNonNull(name, "name must not be null"), Objects.requireNonNull(value, "value must not be null"));
            return this;
        }

        public Builder instanceIpGroupingKey() throws UnknownHostException {
            return this.groupingKey("instance", InetAddress.getLocalHost().getHostAddress());
        }

        public Builder registry(PrometheusRegistry registry) {
            this.registry = Objects.requireNonNull(registry, "registry must not be null");
            return this;
        }

        public Builder escapingScheme(EscapingScheme escapingScheme) {
            this.escapingScheme = Objects.requireNonNull(escapingScheme, "escapingScheme must not be null");
            return this;
        }

        public Builder prometheusTimestampsInMs(boolean prometheusTimestampsInMs) {
            this.prometheusTimestampsInMs = prometheusTimestampsInMs;
            return this;
        }

        public Builder connectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        private Duration getConnectionTimeout(@Nullable ExporterPushgatewayProperties properties) {
            if (properties != null && properties.getConnectTimeout() != null) {
                return properties.getConnectTimeout();
            }
            if (this.connectionTimeout != null) {
                return this.connectionTimeout;
            }
            return Duration.ofSeconds(10L);
        }

        public Builder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        private Duration getReadTimeout(@Nullable ExporterPushgatewayProperties properties) {
            if (properties != null && properties.getReadTimeout() != null) {
                return properties.getReadTimeout();
            }
            if (this.readTimeout != null) {
                return this.readTimeout;
            }
            return Duration.ofSeconds(10L);
        }

        private boolean getPrometheusTimestampsInMs() {
            return this.config.getExporterProperties().getPrometheusTimestampsInMs() || this.prometheusTimestampsInMs;
        }

        private Scheme getScheme(@Nullable ExporterPushgatewayProperties properties) {
            if (properties != null && properties.getScheme() != null) {
                return Scheme.valueOf(properties.getScheme());
            }
            if (this.scheme != null) {
                return this.scheme;
            }
            return Scheme.HTTP;
        }

        private String getAddress(@Nullable ExporterPushgatewayProperties properties) {
            if (properties != null && properties.getAddress() != null) {
                return properties.getAddress();
            }
            if (this.address != null) {
                return this.address;
            }
            return "localhost:9091";
        }

        private String getJob(@Nullable ExporterPushgatewayProperties properties) {
            if (properties != null && properties.getJob() != null) {
                return properties.getJob();
            }
            if (this.job != null) {
                return this.job;
            }
            return DefaultJobLabelDetector.getDefaultJobLabel();
        }

        private EscapingScheme getEscapingScheme(@Nullable ExporterPushgatewayProperties properties) {
            if (properties != null && properties.getEscapingScheme() != null) {
                return properties.getEscapingScheme();
            }
            if (this.escapingScheme != null) {
                return this.escapingScheme;
            }
            return EscapingScheme.UNDERSCORE_ESCAPING;
        }

        private Format getFormat() {
            if (this.format != null) {
                return this.format;
            }
            return Format.PROMETHEUS_PROTOBUF;
        }

        private URL makeUrl(@Nullable ExporterPushgatewayProperties properties) throws UnsupportedEncodingException, MalformedURLException {
            StringBuilder url = new StringBuilder((Object)((Object)this.getScheme(properties)) + "://" + this.getAddress(properties) + "/metrics/");
            String job = this.getJob(properties);
            if (job.contains("/")) {
                url.append("job@base64/").append(this.base64url(job));
            } else {
                url.append("job/").append(URLEncoder.encode(job, "UTF-8"));
            }
            for (Map.Entry<String, String> entry : this.groupingKey.entrySet()) {
                if (entry.getValue().isEmpty()) {
                    url.append("/").append(PrometheusNaming.escapeName((String)entry.getKey(), (EscapingScheme)EscapingScheme.VALUE_ENCODING_ESCAPING)).append("@base64/=");
                    continue;
                }
                if (entry.getValue().contains("/")) {
                    url.append("/").append(PrometheusNaming.escapeName((String)entry.getKey(), (EscapingScheme)EscapingScheme.VALUE_ENCODING_ESCAPING)).append("@base64/").append(this.base64url(entry.getValue()));
                    continue;
                }
                url.append("/").append(PrometheusNaming.escapeName((String)entry.getKey(), (EscapingScheme)EscapingScheme.VALUE_ENCODING_ESCAPING)).append("/").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            return URI.create(url.toString()).normalize().toURL();
        }

        private String base64url(String v) {
            return Base64.getEncoder().encodeToString(v.getBytes(StandardCharsets.UTF_8)).replace("+", "-").replace("/", "_");
        }

        public PushGateway build() {
            ExporterPushgatewayProperties properties = this.config == null ? null : this.config.getExporterPushgatewayProperties();
            try {
                return new PushGateway(this.registry, this.getFormat(), this.makeUrl(properties), this.connectionFactory, this.requestHeaders, this.getPrometheusTimestampsInMs(), this.getEscapingScheme(properties), this.getConnectionTimeout(properties), this.getReadTimeout(properties));
            }
            catch (MalformedURLException e) {
                throw new PrometheusPropertiesException(this.address + ": Invalid address. Expecting <host>:<port>");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

