/*
 * Decompiled with CFR 0.152.
 */
package reactor.blockhound;

import java.util.function.Consumer;
import java.util.function.Predicate;

class BlockHoundRuntime {
    public static volatile Consumer<Object[]> blockingMethodConsumer;
    public static volatile Predicate<Thread> threadPredicate;
    public static volatile Predicate<Thread> dynamicThreadPredicate;
    public static final ThreadLocal<State> STATE;

    BlockHoundRuntime() {
    }

    public static void checkBlocking(String internalClassName, String methodName, int modifiers) {
        boolean isNonBlocking;
        State state = STATE.get();
        if (state == null || state.isAllowed()) {
            return;
        }
        if (state.isDynamic() && !(isNonBlocking = threadPredicate.test(Thread.currentThread()))) {
            return;
        }
        blockingMethodConsumer.accept(new Object[]{internalClassName.replace("/", "."), methodName, modifiers});
    }

    static {
        STATE = ThreadLocal.withInitial(() -> {
            boolean isDynamic = dynamicThreadPredicate.test(Thread.currentThread());
            if (isDynamic) {
                return new State(true);
            }
            boolean isNonBlocking = threadPredicate.test(Thread.currentThread());
            if (isNonBlocking) {
                return new State(false);
            }
            return null;
        });
    }

    public static final class State {
        final boolean dynamic;
        boolean allowed = false;

        public State(boolean dynamic) {
            this(dynamic, false);
        }

        State(boolean dynamic, boolean allowed) {
            this.dynamic = dynamic;
            this.allowed = allowed;
        }

        public boolean isDynamic() {
            return this.dynamic;
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public void setAllowed(boolean allowed) {
            this.allowed = allowed;
        }
    }
}

