/*
 * Decompiled with CFR 0.152.
 */
package reactor.tools.shaded.net.bytebuddy.implementation.bytecode.member;

import reactor.tools.shaded.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import reactor.tools.shaded.net.bytebuddy.implementation.Implementation;
import reactor.tools.shaded.net.bytebuddy.implementation.bytecode.StackManipulation;
import reactor.tools.shaded.net.bytebuddy.jar.asm.MethodVisitor;
import reactor.tools.shaded.net.bytebuddy.utility.JavaConstant;

@HashCodeAndEqualsPlugin.Enhance
public class HandleInvocation
implements StackManipulation {
    private static final String METHOD_HANDLE_NAME = "java/lang/invoke/MethodHandle";
    private static final String INVOKE_EXACT = "invokeExact";
    private final JavaConstant.MethodType methodType;

    public HandleInvocation(JavaConstant.MethodType methodType) {
        this.methodType = methodType;
    }

    public boolean isValid() {
        return true;
    }

    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitMethodInsn(182, METHOD_HANDLE_NAME, INVOKE_EXACT, this.methodType.getDescriptor(), false);
        int size = this.methodType.getReturnType().getStackSize().getSize() - this.methodType.getParameterTypes().getStackSize();
        return new StackManipulation.Size(size, Math.max(size, 0));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.methodType.equals(((HandleInvocation)object).methodType);
    }

    public int hashCode() {
        return 17 * 31 + this.methodType.hashCode();
    }
}

